/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.BinaryRoot;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataRoot;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.ReadableRoot;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.ReadWriteIO;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class InputOutputRoot
implements ReadableRoot,
BinaryRoot {
    private final Charset charset;

    public InputOutputRoot(@NonNull Charset charset) {
        this.charset = Objects.requireNonNull(charset);
    }

    @Override
    public @NonNull String readString() throws IOException {
        return this.openReader(reader -> {
            StringWriter stringWriter = new StringWriter();
            ReadWriteIO.transferToWriter(reader, stringWriter);
            return stringWriter.toString();
        });
    }

    @Override
    public <R> R openReader(final @NonNull DataRoot.Operation<R, @NonNull Reader> operation) throws IOException {
        return this.openInputStream(new DataRoot.Operation<R, InputStream>(){

            @Override
            public boolean handlesBuffering() {
                return operation.handlesBuffering();
            }

            @Override
            public R operateUsing(InputStream inputStream) throws IOException {
                try (InputStreamReader reader = new InputStreamReader(inputStream, InputOutputRoot.this.charset);){
                    Object r = operation.operateUsing(reader);
                    return r;
                }
            }
        });
    }

    @Override
    public void writeString(@NonNull String content) throws IOException {
        this.openWriter(writer -> {
            writer.write(content);
            return null;
        });
    }

    @Override
    public <R> R openWriter(final @NonNull DataRoot.Operation<R, @NonNull Writer> operation) throws IOException {
        return this.openOutputStream(new DataRoot.Operation<R, OutputStream>(){

            @Override
            public boolean handlesBuffering() {
                return operation.handlesBuffering();
            }

            @Override
            public R operateUsing(OutputStream outputStream) throws IOException {
                try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, InputOutputRoot.this.charset);){
                    Object r = operation.operateUsing(writer);
                    return r;
                }
            }
        });
    }

    @Override
    public <R> R openReadChannel(final @NonNull DataRoot.Operation<R, @NonNull ReadableByteChannel> operation) throws IOException {
        return this.openInputStream(new DataRoot.Operation<R, InputStream>(){

            @Override
            public boolean handlesBuffering() {
                return operation.handlesBuffering();
            }

            @Override
            public R operateUsing(InputStream inputStream) throws IOException {
                try (ReadableByteChannel inputChannel = Channels.newChannel(inputStream);){
                    Object r = operation.operateUsing(inputChannel);
                    return r;
                }
            }
        });
    }

    @Override
    public <R> R openWriteChannel(final @NonNull DataRoot.Operation<R, @NonNull WritableByteChannel> operation) throws IOException {
        return this.openOutputStream(new DataRoot.Operation<R, OutputStream>(){

            @Override
            public boolean handlesBuffering() {
                return operation.handlesBuffering();
            }

            @Override
            public R operateUsing(OutputStream outputStream) throws IOException {
                try (WritableByteChannel outputChannel = Channels.newChannel(outputStream);){
                    Object r = operation.operateUsing(outputChannel);
                    return r;
                }
            }
        });
    }
}

