/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.EscapeString;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;

public class EscapeStringTest {
    @TestFactory
    public Stream<DynamicTest> roundTrip() {
        return Stream.generate(() -> {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            int[] data = new int[8];
            for (int n = 0; n < data.length; ++n) {
                data[n] = random.nextInt(0, 0x10FFFF);
            }
            return new String(data, 0, data.length);
        }).limit(100L).map(string -> DynamicTest.dynamicTest((String)("For data " + string), () -> {
            String quotedAsLiteral = new EscapeString((String)string).printString();
            String inner = quotedAsLiteral.substring(1, quotedAsLiteral.length() - 1);
            Assertions.assertEquals((Object)string, (Object)StringEscapeUtils.unescapeJava((String)inner), () -> "Failed to recuperate string \n" + string + "\n. Quoted literal was \n" + quotedAsLiteral);
        }));
    }
}

