/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Printable;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.NonNull;

final class EscapeString
extends Printable.Abstract {
    private final String val;

    EscapeString(String val) {
        this.val = val;
    }

    @Override
    public void printTo(@NonNull Appendable output) throws IOException {
        output.append('\"');
        class ErrorHold {
            IOException error;

            ErrorHold() {
            }
        }
        ErrorHold errorHold = new ErrorHold();
        this.val.codePoints().forEach(character -> {
            if (errorHold.error != null) {
                return;
            }
            try {
                switch (character) {
                    case 34: {
                        output.append("\\\"");
                        break;
                    }
                    case 92: {
                        output.append("\\\\");
                        break;
                    }
                    case 8: {
                        output.append("\\b");
                        break;
                    }
                    case 12: {
                        output.append("\\f");
                        break;
                    }
                    case 10: {
                        output.append("\\n");
                        break;
                    }
                    case 13: {
                        output.append("\\r");
                        break;
                    }
                    case 9: {
                        output.append("\\t");
                        break;
                    }
                    default: {
                        if (Character.isISOControl(character)) {
                            output.append("\\u");
                            String code = Integer.toHexString(character);
                            for (int n = code.length(); n < 4; ++n) {
                                output.append('0');
                            }
                            output.append(code);
                            break;
                        }
                        if (Character.isBmpCodePoint(character)) {
                            output.append((char)character);
                            break;
                        }
                        for (char ch : Character.toChars(character)) {
                            output.append(ch);
                        }
                        break;
                    }
                }
            }
            catch (IOException ex) {
                errorHold.error = ex;
            }
        });
        if (errorHold.error != null) {
            throw errorHold.error;
        }
        output.append('\"');
    }
}

