/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ImmutabilityGuard;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataList;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.CommentLocation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataTreeTest {
    @Test
    public void populateEntries() {
        Object[] validValues;
        DataTree.Mut dataTree = new DataTree.Mut();
        Assertions.assertTrue((boolean)dataTree.isEmpty());
        Assertions.assertEquals((int)0, (int)dataTree.size());
        dataTree.put("hello", new DataEntry("goodbye"));
        dataTree.put(1, new DataEntry("key is not a string"));
        Assertions.assertFalse((boolean)dataTree.isEmpty());
        Assertions.assertEquals((int)2, (int)dataTree.size());
        for (Object validValue : validValues = new Object[]{3, (byte)4, Long.MAX_VALUE, Double.MIN_VALUE, Float.valueOf(42.7f), false, Character.valueOf('c'), "string", new DataList.Immut(new DataEntry(4), new DataEntry(true), new DataEntry("list of mixed types")), dataTree}) {
            Assertions.assertEquals((Object)validValue, (Object)new DataEntry(validValue).getValue());
            Assertions.assertEquals((Object)validValue, (Object)new DataEntry(validValue).withComments(CommentLocation.ABOVE, List.of()).getValue());
            Assertions.assertEquals((Object)validValue, (Object)new DataEntry(validValue).withLineNumber(14).getValue());
        }
        Assertions.assertThrows(RuntimeException.class, () -> new DataEntry(null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DataEntry(new Object()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DataEntry(List.of("hi there", new Object())));
    }

    @Test
    public void iterateInOrder() {
        DataTree.Mut dataTreeMut = new DataTree.Mut();
        dataTreeMut.put("hello", new DataEntry("goodbye"));
        dataTreeMut.put("also", new DataEntry("yes"));
        dataTreeMut.put("zed", new DataEntry(true));
        ArrayList orderedKeys = new ArrayList();
        ArrayList orderedValues = new ArrayList();
        dataTreeMut.forEach((k, v) -> {
            orderedKeys.add(k);
            orderedValues.add(v.getValue());
        });
        Assertions.assertEquals(orderedKeys, List.of("hello", "also", "zed"));
        Assertions.assertEquals(orderedValues, List.of("goodbye", "yes", Boolean.valueOf(true)));
    }

    @Test
    public void mergeFrom() {
        DataTree.Mut mergeFromDest = new DataTree.Mut();
        DataTree.Mut section = new DataTree.Mut();
        mergeFromDest.put("hello", new DataEntry("goodbye"));
        mergeFromDest.put("zed", new DataEntry(true));
        mergeFromDest.put("section", new DataEntry(section));
        mergeFromDest.put("original-section", new DataEntry(new DataTree.Mut()));
        mergeFromDest.put("original-not-section", new DataEntry(false));
        DataTree.Mut mergeFromSource = new DataTree.Mut();
        DataTree.Mut sectionNew = new DataTree.Mut();
        sectionNew.put("sub", new DataEntry("value"));
        mergeFromSource.put("hello", new DataEntry("replaced"));
        mergeFromSource.put("new key", new DataEntry(true));
        mergeFromSource.put("section", new DataEntry(sectionNew.intoImmut()));
        mergeFromSource.put("original-section", new DataEntry("no longer section"));
        mergeFromSource.put("original-not-section", new DataEntry(new DataTree.Immut()));
        mergeFromDest.copyFrom(mergeFromSource.intoImmut());
        mergeFromSource.forEach((key, expectedEntry) -> Assertions.assertEquals((Object)expectedEntry, (Object)mergeFromDest.get(key)));
        Assertions.assertEquals((Object)new DataEntry(true), (Object)mergeFromDest.get("zed"));
    }

    @Test
    public void mergeFromFailure() {
        DataTree.Mut mergeFromDest = new DataTree.Mut();
        mergeFromDest.put("hello", new DataEntry("goodbye"));
        mergeFromDest.put("also", new DataEntry("yes"));
        mergeFromDest.put("section", new DataEntry(new DataTree.Immut()));
        DataTree.Mut mergeFromSource = new DataTree.Mut();
        mergeFromSource.put("hello", new DataEntry("replaced"));
        mergeFromSource.put("new key", new DataEntry(true));
        mergeFromSource.put("section", new DataEntry(new DataTree.Mut()));
        Assertions.assertThrows(IllegalStateException.class, () -> mergeFromDest.copyFrom(mergeFromSource));
    }

    @Test
    public void intoMutOnMut() {
        DataTree.Mut dataTreeMut = new DataTree.Mut();
        dataTreeMut.put("hello", new DataEntry("goodbye"));
        Assertions.assertSame((Object)dataTreeMut, (Object)dataTreeMut.intoMut());
    }

    @Test
    public void intoImmut() {
        DataTree.Mut dataTreeMut = new DataTree.Mut();
        dataTreeMut.put("hello", new DataEntry("goodbye"));
        dataTreeMut.put("also", new DataEntry("yes"));
        dataTreeMut.put("zed", new DataEntry(true));
        DataTree.Immut dataTreeImmut = dataTreeMut.intoImmut();
        Assertions.assertEquals((Object)dataTreeImmut, (Object)dataTreeMut);
        Assertions.assertSame((Object)dataTreeImmut, (Object)dataTreeImmut.intoImmut());
    }

    @Test
    public void intoImmutMutRoundTrip() {
        DataTree.Mut dataTreeMut = new DataTree.Mut();
        dataTreeMut.put("hello", new DataEntry("goodbye"));
        dataTreeMut.put("also", new DataEntry("yes"));
        dataTreeMut.put("zed", new DataEntry(true));
        Assertions.assertEquals((Object)dataTreeMut, (Object)dataTreeMut.intoImmut().intoMut());
    }

    @Test
    public void intoMutOnImmutCannotMutateImmut() {
        DataTree.Mut dataTreeMut = new DataTree.Mut();
        dataTreeMut.put("hello", new DataEntry("goodbye"));
        DataTree.Immut snapshot = dataTreeMut.intoImmut();
        try (ImmutGuard guard = new ImmutGuard(snapshot, new DataTree.Immut[0]);){
            DataTree.Mut backToMut1 = snapshot.intoMut();
            backToMut1.put("new key", new DataEntry("new value"));
            guard.check();
            Assertions.assertNotEquals((Object)backToMut1, (Object)snapshot);
            DataTree.Mut backToMut2 = snapshot.intoMut();
            backToMut2.remove("hello");
            guard.check();
            Assertions.assertNotEquals((Object)backToMut2, (Object)snapshot);
            DataTree.Mut backToMut3 = snapshot.intoMut();
            backToMut3.remove("hello");
            guard.check();
            Assertions.assertNotEquals((Object)backToMut3, (Object)snapshot);
            DataTree.Mut backToMut4 = snapshot.intoMut();
            backToMut4.clear();
            Assertions.assertNotEquals((Object)backToMut4, (Object)snapshot);
            DataTree.Mut backToMut5 = snapshot.intoMut();
            backToMut5.copyFrom(backToMut1);
            Assertions.assertNotEquals((Object)backToMut5, (Object)snapshot);
            Assertions.assertEquals((Object)backToMut2, (Object)backToMut3);
            Assertions.assertEquals((Object)backToMut3, (Object)backToMut4);
            Assertions.assertEquals((Object)backToMut5, (Object)backToMut1);
        }
    }

    @Test
    public void intoImmutOnMutCannotBeMutatedBySet() {
        DataTree.Mut dataTreeMut = new DataTree.Mut();
        dataTreeMut.put("hello", new DataEntry("goodbye"));
        dataTreeMut.put("also", new DataEntry("yes"));
        dataTreeMut.put("zed", new DataEntry(true));
        DataTree.Immut snapshot = dataTreeMut.intoImmut();
        try (ImmutGuard ignored = new ImmutGuard(snapshot, new DataTree.Immut[0]);){
            dataTreeMut.put("new key", new DataEntry("new value"));
        }
    }

    @Test
    public void intoImmutOnMutCannotBeMutatedBySetNull() {
        DataTree.Mut dataTreeMut = new DataTree.Mut();
        dataTreeMut.put("hello", new DataEntry("goodbye"));
        dataTreeMut.put("also", new DataEntry("yes"));
        dataTreeMut.put("zed", new DataEntry(true));
        DataTree.Immut snapshot = dataTreeMut.intoImmut();
        try (ImmutGuard ignored = new ImmutGuard(snapshot, new DataTree.Immut[0]);){
            dataTreeMut.remove("hello");
        }
    }

    @Test
    public void intoImmutOnMutCannotBeMutatedByRemove() {
        DataTree.Mut dataTreeMut = new DataTree.Mut();
        dataTreeMut.put("hello", new DataEntry("goodbye"));
        dataTreeMut.put("also", new DataEntry("yes"));
        dataTreeMut.put("zed", new DataEntry(true));
        DataTree.Immut snapshot = dataTreeMut.intoImmut();
        try (ImmutGuard ignored = new ImmutGuard(snapshot, new DataTree.Immut[0]);){
            dataTreeMut.remove("hello");
        }
    }

    @Test
    public void intoImmutOnMutCannotBeMutatedByClear() {
        DataTree.Mut dataTreeMut = new DataTree.Mut();
        dataTreeMut.put("hello", new DataEntry("goodbye"));
        dataTreeMut.put("also", new DataEntry("yes"));
        dataTreeMut.put("zed", new DataEntry(true));
        DataTree.Immut snapshot = dataTreeMut.intoImmut();
        try (ImmutGuard ignored = new ImmutGuard(snapshot, new DataTree.Immut[0]);){
            dataTreeMut.clear();
        }
    }

    @Test
    public void intoImmutOnMutCannotBeMutatedByMergeFrom() {
        DataTree.Mut dataTreeMut = new DataTree.Mut();
        dataTreeMut.put("hello", new DataEntry("goodbye"));
        dataTreeMut.put("also", new DataEntry("yes"));
        dataTreeMut.put("zed", new DataEntry(true));
        DataTree.Mut mergeFromSource = new DataTree.Mut();
        mergeFromSource.put("hi", new DataEntry("bye"));
        DataTree.Immut snapshot = dataTreeMut.intoImmut();
        try (ImmutGuard ignored = new ImmutGuard(snapshot, new DataTree.Immut[0]);){
            dataTreeMut.copyFrom(mergeFromSource);
        }
    }

    @Test
    public void equality() throws ClassNotFoundException {
        Class.forName(NonNull.class.getName());
        EqualsVerifier.simple().forClass(DataTree.class).verify();
    }

    @Test
    public void toStringTest() {
        Assertions.assertTrue((boolean)new DataTree.Mut().toString().contains("Mut"));
        Assertions.assertTrue((boolean)new DataTree.Immut().toString().contains("Immut"));
    }

    static class ImmutGuard
    extends ImmutabilityGuard<DataTree.Immut, Map<Object, DataEntry>> {
        protected ImmutGuard(DataTree.Immut value, DataTree.Immut ... extra) {
            super(value, extra);
        }

        @Override
        protected Map<Object, DataEntry> takeSnapshot(DataTree.Immut value) {
            HashMap snapshot = new HashMap();
            value.forEach((key, entry) -> snapshot.put(key.toString(), entry));
            return Map.copyOf(snapshot);
        }
    }
}

