/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataList;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataToString;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public abstract class DataTree {
    @NonNull LinkedHashMap<Object, DataEntry> data;

    DataTree(LinkedHashMap<Object, DataEntry> data) {
        this.data = data;
    }

    @Pure
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Pure
    public int size() {
        return this.data.size();
    }

    @SideEffectFree
    public @NonNull Set<@NonNull Object> keySet() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    @Pure
    public abstract @Nullable DataEntry get(@NonNull Object var1);

    @SideEffectFree
    public abstract void forEach(BiConsumer<? super @NonNull Object, ? super @NonNull DataEntry> var1);

    @SideEffectFree
    public abstract @NonNull Immut intoImmut();

    @SideEffectFree
    public abstract @NonNull Mut intoMut();

    public static boolean validateKey(@Nullable Object value) {
        return value instanceof String || value instanceof Boolean || value instanceof Byte || value instanceof Character || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTree)) {
            return false;
        }
        DataTree dataTree = (DataTree)o;
        return this.data.equals(dataTree.data);
    }

    public final int hashCode() {
        return this.data.hashCode();
    }

    public final String toString() {
        return DataToString.implToString(this);
    }

    void toString(DataToString.Scope output) {
        output.append(this.getClass().getSimpleName());
        output.mapToString(this.data);
    }

    public static final class Mut
    extends DataTree {
        private int state;
        private static final int NORMAL = 0;
        private static final int FROZEN_COMING_FROM_IMMUT = 1;
        private static final int FROZEN_GOING_TO_IMMUT = 2;

        public Mut() {
            super(new LinkedHashMap<Object, DataEntry>());
        }

        Mut(LinkedHashMap<Object, DataEntry> data) {
            super(data);
        }

        @Override
        public @Nullable DataEntry get(@NonNull Object key) {
            Object value;
            DataEntry entry = (DataEntry)this.data.get(key);
            if (this.state == 1 && entry != null && ((value = entry.getValue()) instanceof Immut || value instanceof DataList.Immut)) {
                this.ensureMutable();
                entry = (DataEntry)this.data.get(key);
            }
            return entry;
        }

        @Override
        public void forEach(BiConsumer<? super @NonNull Object, ? super @NonNull DataEntry> action) {
            if (this.state == 1) {
                this.ensureMutable();
            }
            this.data.forEach(action);
        }

        @Override
        public @NonNull Immut intoImmut() {
            if (this.state == 0) {
                this.state = 2;
            }
            Immut immut = new Immut(this.data);
            immut.needDeepCopy = true;
            return immut;
        }

        @Override
        public @NonNull Mut intoMut() {
            return this;
        }

        private void ensureMutable() {
            switch (this.state) {
                case 2: {
                    this.data = new LinkedHashMap(this.data);
                    break;
                }
                case 1: {
                    LinkedHashMap newData = new LinkedHashMap(this.data.size());
                    this.data.forEach((? super K key, ? super V entry) -> newData.put(key, entry.intoMutDeep()));
                    this.data = newData;
                    break;
                }
            }
            this.state = 0;
        }

        public @Nullable DataEntry put(@NonNull Object key, @NonNull DataEntry entry) {
            Objects.requireNonNull(entry, "entry");
            if (!Mut.validateKey(key)) {
                throw new IllegalArgumentException("Not a canonical key: " + key);
            }
            this.ensureMutable();
            return this.data.put(key, entry);
        }

        public void remove(@NonNull Object key) {
            if (!Mut.validateKey(key)) {
                throw new IllegalArgumentException("Not a canonical key: " + key);
            }
            this.ensureMutable();
            this.data.remove(key);
        }

        public void clear() {
            this.ensureMutable();
            this.data.clear();
        }

        public void copyFrom(@NonNull DataTree source) {
            this.ensureMutable();
            source.forEach((key, copyEntry) -> {
                Object copyValue = copyEntry.getValue();
                if (copyValue instanceof DataTree) {
                    DataTree copyTree = (DataTree)copyValue;
                    DataEntry existingEntry = (DataEntry)this.data.get(key);
                    if (existingEntry != null) {
                        Object existingValue = existingEntry.getValue();
                        if (existingValue instanceof Mut) {
                            ((Mut)existingValue).copyFrom(copyTree);
                            return;
                        }
                        if (existingValue instanceof Immut) {
                            throw new IllegalStateException("Tried to merge into data tree at " + key + " but it is immutable");
                        }
                    }
                }
                this.data.put(key, copyEntry);
            });
        }
    }

    public static final class Immut
    extends DataTree {
        private boolean needDeepCopy;

        public Immut() {
            super(new LinkedHashMap<Object, DataEntry>(1, 0.99f));
        }

        Immut(LinkedHashMap<Object, DataEntry> data) {
            super(data);
        }

        @Override
        public @Nullable DataEntry get(@NonNull Object key) {
            Object value;
            DataEntry entry = (DataEntry)this.data.get(key);
            if (this.needDeepCopy && entry != null && ((value = entry.getValue()) instanceof Mut || value instanceof DataList.Mut)) {
                this.makeDeepCopy();
                this.needDeepCopy = false;
                entry = (DataEntry)this.data.get(key);
            }
            return entry;
        }

        @Override
        public void forEach(BiConsumer<? super @NonNull Object, ? super @NonNull DataEntry> action) {
            if (this.needDeepCopy) {
                this.makeDeepCopy();
                this.needDeepCopy = false;
            }
            this.data.forEach(action);
        }

        @Override
        public @NonNull Immut intoImmut() {
            return this;
        }

        @Override
        public @NonNull Mut intoMut() {
            Mut mutCopy = new Mut(this.data);
            mutCopy.state = 1;
            return mutCopy;
        }

        private void makeDeepCopy() {
            LinkedHashMap newData = new LinkedHashMap(this.data.size());
            this.data.forEach((? super K key, ? super V entry) -> newData.put(key, entry.intoImmutDeep()));
            this.data = newData;
        }
    }
}

