/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.CommentData;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataList;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.CommentLocation;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataToStringTest {
    @Test
    public void simpleTrees() {
        DataTree.Mut dataTree = new DataTree.Mut();
        dataTree.put("hi", new DataEntry(1));
        dataTree.put("newliner", new DataEntry("line:\n"));
        dataTree.put("subtree", new DataEntry(new DataTree.Immut()));
        Assertions.assertEquals((Object)"Mut{\n  hi=DataEntry{value=1},\n  newliner=DataEntry{value=\"line:\\n\"},\n  subtree=DataEntry{value=Immut{}},\n}", (Object)dataTree.toString());
    }

    @Test
    public void simpleLists() {
        DataList.Mut entryList = new DataList.Mut();
        entryList.add(new DataEntry(false));
        entryList.add(new DataEntry("hello").withLineNumber(5));
        entryList.add(new DataEntry(new DataList.Immut()));
        DataEntry topEntry = new DataEntry(entryList);
        Assertions.assertEquals((Object)"DataEntry{value=Mut[\n  DataEntry{value=false},\n  DataEntry{value=\"hello\", lineNumber=5},\n  DataEntry{value=Immut[]},\n]}", (Object)topEntry.toString());
    }

    @Test
    public void entryWithComments() {
        DataEntry withComments = new DataEntry(4).withComments(CommentData.empty().setAt(CommentLocation.ABOVE, "above1", "above2").setAt(CommentLocation.INLINE, "inline"));
        Assertions.assertEquals((Object)"DataEntry{value=4, comments={ABOVE=[above1, above2], INLINE=[inline]}}", (Object)withComments.toString());
        Assertions.assertEquals((Object)"DataEntry{value=4, lineNumber=5, comments={ABOVE=[above1, above2], INLINE=[inline]}}", (Object)withComments.withLineNumber(5).toString());
    }

    @Test
    public void complexTree() {
        DataTree.Mut dataTree = new DataTree.Mut();
        dataTree.put("hi", new DataEntry(1));
        DataTree.Mut subTree = new DataTree.Mut();
        subTree.put("subkey", new DataEntry(true).withLineNumber(10));
        subTree.put("escape-value", new DataEntry("\u007f"));
        dataTree.put("subtree", new DataEntry(subTree));
        ArrayList<DataEntry> entryList = new ArrayList<DataEntry>();
        entryList.add(new DataEntry(false));
        entryList.add(new DataEntry(new DataList.Mut()));
        dataTree.put("list", new DataEntry(new DataList.Immut(entryList)));
        Assertions.assertEquals((Object)"Mut{\n  hi=DataEntry{value=1},\n  subtree=DataEntry{value=Mut{\n    subkey=DataEntry{value=true, lineNumber=10},\n    escape-value=DataEntry{value=\"\\u007f\"},\n  }},\n  list=DataEntry{value=Immut[\n    DataEntry{value=false},\n    DataEntry{value=Mut[]},\n  ]},\n}", (Object)dataTree.toString());
    }
}

