/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataList;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.EscapeString;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class DataToString {
    private final StringBuilder output;
    private final Set<Object> parentContainers = Collections.newSetFromMap(new IdentityHashMap());

    DataToString(StringBuilder output) {
        this.output = output;
    }

    static String implToString(Object implementor) {
        StringBuilder output = new StringBuilder();
        Scope topScope = new DataToString(output).new Scope(0);
        if (implementor instanceof DataEntry) {
            ((DataEntry)implementor).toString(topScope);
        } else {
            topScope.valueToString(implementor);
        }
        return output.toString();
    }

    final class Scope {
        private final int indent;

        Scope(int indent) {
            this.indent = indent;
        }

        private void writeNewLine() {
            DataToString.this.output.append('\n');
            for (int n = 0; n < this.indent; ++n) {
                DataToString.this.output.append(' ');
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void valueToString(Object value) {
            if (value instanceof String) {
                new EscapeString((String)value).printTo(DataToString.this.output);
            } else if (value instanceof DataList) {
                DataList dataList = (DataList)value;
                if (DataToString.this.parentContainers.add(dataList)) {
                    try {
                        dataList.toString(this);
                    }
                    finally {
                        DataToString.this.parentContainers.remove(dataList);
                    }
                } else {
                    DataToString.this.output.append("<circular list>");
                }
            } else if (value instanceof DataTree) {
                DataTree dataTree = (DataTree)value;
                if (DataToString.this.parentContainers.add(dataTree)) {
                    try {
                        dataTree.toString(this);
                    }
                    finally {
                        DataToString.this.parentContainers.remove(dataTree);
                    }
                } else {
                    DataToString.this.output.append("<circular map>");
                }
            } else {
                DataToString.this.output.append(value);
            }
        }

        void listToString(List<DataEntry> list) {
            DataToString.this.output.append('[');
            if (!list.isEmpty()) {
                new Scope(this.indent + 2).listElementsToString(list);
                this.writeNewLine();
            }
            DataToString.this.output.append(']');
        }

        private void listElementsToString(List<DataEntry> list) {
            for (DataEntry elem : list) {
                this.writeNewLine();
                elem.toString(this);
                DataToString.this.output.append(',');
            }
        }

        void mapToString(Map<Object, DataEntry> map) {
            DataToString.this.output.append('{');
            if (!map.isEmpty()) {
                new Scope(this.indent + 2).mapElementsToString(map);
                this.writeNewLine();
            }
            DataToString.this.output.append('}');
        }

        private void mapElementsToString(Map<Object, DataEntry> map) {
            for (Map.Entry<Object, DataEntry> mapEntry : map.entrySet()) {
                Object key = mapEntry.getKey();
                DataEntry entry = mapEntry.getValue();
                this.writeNewLine();
                DataToString.this.output.append(key);
                DataToString.this.output.append('=');
                entry.toString(this);
                DataToString.this.output.append(',');
            }
        }

        void append(String str) {
            DataToString.this.output.append(str);
        }

        void append(char ch) {
            DataToString.this.output.append(ch);
        }
    }
}

