/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Utilities;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataList;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class DataListTest {
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void empty(boolean mutable) {
        DataList dataList = mutable ? new DataList.Mut() : new DataList.Immut();
        Assertions.assertTrue((boolean)dataList.isEmpty());
        Assertions.assertEquals((int)0, (int)dataList.size());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> dataList.get(-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> dataList.get(0));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void populateEntries(boolean mutable) {
        DataList.Mut mutList = new DataList.Mut();
        mutList.add(new DataEntry(1));
        mutList.add(new DataEntry("hello"));
        DataList dataList = mutable ? mutList : mutList.intoImmut();
        Assertions.assertFalse((boolean)dataList.isEmpty());
        Assertions.assertEquals((int)2, (int)dataList.size());
        Assertions.assertEquals((Object)new DataEntry(1), (Object)dataList.get(0));
        Assertions.assertEquals((Object)new DataEntry("hello"), (Object)dataList.get(1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> dataList.get(-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> dataList.get(2));
        ArrayList values = new ArrayList();
        dataList.forEach(entry -> values.add(entry.getValue()));
        Assertions.assertEquals(List.of(Integer.valueOf(1), "hello"), values);
    }

    @Test
    public void equality() {
        DataList.Mut list1 = new DataList.Mut();
        list1.add(new DataEntry(1));
        list1.add(new DataEntry("hello"));
        DataList.Mut list2 = new DataList.Mut();
        list2.add(new DataEntry(1));
        list2.add(new DataEntry("hello"));
        DataList.Immut list3 = list1.intoImmut();
        DataList.Immut list4 = list1.intoImmut();
        DataList.Mut list5 = new DataList.Mut();
        list5.add(new DataEntry(1));
        Utilities.assertEqualsBothWays(list1, list1);
        Utilities.assertEqualsBothWays(list1, list2);
        Utilities.assertEqualsBothWays(list3, list3);
        Utilities.assertEqualsBothWays(list3, list4);
        Utilities.assertEqualsBothWays(list1, list3);
        Utilities.assertNotEqualsBothWays(list5, null);
        Utilities.assertNotEqualsBothWays(list5, new Object());
        Utilities.assertNotEqualsBothWays(list1, list5);
        Utilities.assertNotEqualsBothWays(list3, list5);
    }

    @Test
    public void modify() {
        DataList.Mut dataList = new DataList.Mut();
        dataList.add(new DataEntry(1));
        dataList.add(new DataEntry("hello"));
        dataList.set(0, new DataEntry(2));
        ArrayList values = new ArrayList();
        dataList.forEach(entry -> values.add(entry.getValue()));
        Assertions.assertEquals(List.of(Integer.valueOf(2), "hello"), values);
        dataList.clear();
        Assertions.assertTrue((boolean)dataList.isEmpty());
        Assertions.assertEquals((int)0, (int)dataList.size());
        ArrayList valuesNow = new ArrayList();
        dataList.forEach(entry -> valuesNow.add(entry.getValue()));
        Assertions.assertEquals(List.of(), valuesNow);
    }
}

