/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataToString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public abstract class DataList {
    @Pure
    public abstract boolean isEmpty();

    @Pure
    public abstract int size();

    @SideEffectFree
    public abstract @NonNull Immut intoImmut();

    @SideEffectFree
    public abstract @NonNull Mut intoMut();

    @Pure
    public abstract @NonNull DataEntry get(int var1);

    @SideEffectFree
    public abstract void forEach(Consumer<? super @NonNull DataEntry> var1);

    abstract List<DataEntry> readOnlyList();

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataList)) {
            return false;
        }
        DataList dataList = (DataList)o;
        return this.readOnlyList().equals(dataList.readOnlyList());
    }

    public final int hashCode() {
        return this.readOnlyList().hashCode();
    }

    public final String toString() {
        return DataToString.implToString(this);
    }

    void toString(DataToString.Scope output) {
        output.append(this.getClass().getSimpleName());
        output.listToString(this.readOnlyList());
    }

    public static final class Mut
    extends DataList {
        private final ArrayList<DataEntry> data;

        Mut(ArrayList<DataEntry> data) {
            this.data = data;
        }

        public Mut() {
            this(new ArrayList<DataEntry>());
        }

        public Mut(int initialCapacity) {
            this(new ArrayList<DataEntry>(initialCapacity));
        }

        public Mut(DataEntry ... entries) {
            this(entries.length);
            for (DataEntry datum : entries) {
                Objects.requireNonNull(datum);
                this.data.add(datum);
            }
        }

        public Mut(@NonNull Collection<@NonNull DataEntry> entries) {
            this(entries.size());
            for (DataEntry datum : entries) {
                Objects.requireNonNull(datum);
                this.data.add(datum);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        @Override
        public int size() {
            return this.data.size();
        }

        @Override
        public @NonNull Immut intoImmut() {
            int size = this.data.size();
            DataEntry[] array = new DataEntry[size];
            for (int n = 0; n < size; ++n) {
                array[n] = this.data.get(n).intoImmutDeep();
            }
            return new Immut(array, true);
        }

        @Override
        public @NonNull Mut intoMut() {
            return this;
        }

        @Override
        public @NonNull DataEntry get(int idx) {
            return this.data.get(idx);
        }

        @Override
        public void forEach(Consumer<? super @NonNull DataEntry> action) {
            this.data.forEach((Consumer<DataEntry>)action);
        }

        @Override
        List<DataEntry> readOnlyList() {
            return this.data;
        }

        public void add(@NonNull DataEntry entry) {
            this.data.add(Objects.requireNonNull(entry));
        }

        public void set(int idx, @NonNull DataEntry entry) {
            this.data.set(idx, entry);
        }

        public void clear() {
            this.data.clear();
        }
    }

    public static final class Immut
    extends DataList {
        private final DataEntry[] data;

        public Immut() {
            this(new DataEntry[0], true);
        }

        public Immut(DataEntry ... entries) {
            DataEntry[] data;
            for (DataEntry datum : data = (DataEntry[])entries.clone()) {
                Objects.requireNonNull(datum);
            }
            this.data = data;
        }

        public Immut(@NonNull Collection<@NonNull DataEntry> entries) {
            DataEntry[] data;
            for (DataEntry datum : data = entries.toArray(new DataEntry[0])) {
                Objects.requireNonNull(datum);
            }
            this.data = data;
        }

        Immut(DataEntry[] data, boolean privileged) {
            this.data = data;
        }

        @Override
        public boolean isEmpty() {
            return this.data.length == 0;
        }

        @Override
        public int size() {
            return this.data.length;
        }

        @Override
        public @NonNull Immut intoImmut() {
            return this;
        }

        @Override
        public @NonNull Mut intoMut() {
            ArrayList<DataEntry> list = new ArrayList<DataEntry>(this.data.length);
            for (DataEntry datum : this.data) {
                list.add(datum.intoMutDeep());
            }
            return new Mut(list);
        }

        @Override
        public @NonNull DataEntry get(int idx) {
            return this.data[idx];
        }

        @Override
        public void forEach(Consumer<? super @NonNull DataEntry> action) {
            for (DataEntry datum : this.data) {
                action.accept(datum);
            }
        }

        @Override
        List<DataEntry> readOnlyList() {
            return Arrays.asList(this.data);
        }
    }
}

