/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.CommentData;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.CommentLocation;
import java.util.LinkedHashMap;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataEntryTest {
    private final DataEntry entry = new DataEntry("value");

    @Test
    public void constructor() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DataEntry(new DataEntryTest()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DataEntry(new LinkedHashMap()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DataEntry(null));
    }

    @Test
    public void value() {
        DataEntry another = this.entry.withValue("another");
        Assertions.assertEquals((Object)"value", (Object)this.entry.getValue());
        Assertions.assertEquals((Object)"another", (Object)another.getValue());
    }

    @Test
    public void lineNumber() {
        DataEntry firstEntry = new DataEntry(45);
        Assertions.assertNull((Object)firstEntry.getLineNumber());
        DataEntry entryWith42 = firstEntry.withLineNumber(42);
        Assertions.assertEquals((int)42, (Integer)entryWith42.getLineNumber());
        Assertions.assertNull((Object)firstEntry.getLineNumber());
        DataEntry clearedAgain = entryWith42.clearLineNumber();
        Assertions.assertNull((Object)clearedAgain.getLineNumber());
        Assertions.assertEquals((int)42, (Integer)entryWith42.getLineNumber());
    }

    @Test
    public void comments() {
        CommentData comments = CommentData.empty().setAt(CommentLocation.ABOVE, "hi").setAt(CommentLocation.INLINE, "other location", "second line", "third line");
        DataEntry commented = this.entry.withComments(comments);
        Assertions.assertEquals((Object)comments, (Object)commented.getComments());
        Assertions.assertEquals(List.of("hi"), commented.getComments(CommentLocation.ABOVE));
        Assertions.assertEquals(List.of("other location", "second line", "third line"), commented.getComments(CommentLocation.INLINE));
        Assertions.assertEquals(List.of(), commented.getComments(CommentLocation.BELOW));
    }

    @Test
    public void validateValue() {
        Assertions.assertTrue((boolean)DataEntry.validateValue("hi"));
        Assertions.assertTrue((boolean)DataEntry.validateValue(0));
        Assertions.assertTrue((boolean)DataEntry.validateValue(0L));
        Assertions.assertTrue((boolean)DataEntry.validateValue(Float.valueOf(0.0f)));
        Assertions.assertTrue((boolean)DataEntry.validateValue(0.0));
        Assertions.assertTrue((boolean)DataEntry.validateValue((byte)0));
        Assertions.assertTrue((boolean)DataEntry.validateValue((short)0));
        Assertions.assertTrue((boolean)DataEntry.validateValue(false));
        Assertions.assertTrue((boolean)DataEntry.validateValue(Character.valueOf('c')));
        Assertions.assertTrue((boolean)DataEntry.validateValue(new DataTree.Immut()));
        Assertions.assertFalse((boolean)DataEntry.validateValue(new int[]{1, 3, 4}));
        Assertions.assertFalse((boolean)DataEntry.validateValue(this));
        Assertions.assertFalse((boolean)DataEntry.validateValue(new LinkedHashMap()));
        Assertions.assertFalse((boolean)DataEntry.validateValue(null));
    }

    @Test
    public void equals() {
        EqualsVerifier.forClass(DataEntry.class).withOnlyTheseFields(new String[]{"value"}).verify();
    }

    @Test
    public void toStringTest() {
        Assertions.assertTrue((boolean)new DataEntry("hello").toString().contains(DataEntry.class.getSimpleName()));
        Assertions.assertTrue((boolean)new DataEntry("hello").toString().contains("hello"));
    }
}

