/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.CommentData;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataList;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataToString;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.CommentLocation;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public final class DataEntry {
    private final @NonNull Object value;
    private final Integer lineNumber;
    private final CommentData comments;

    public DataEntry(@NonNull Object value) {
        this(value, null, CommentData.empty());
    }

    private DataEntry(@NonNull Object value, Integer lineNumber, CommentData comments) {
        if (!DataEntry.validateValue(value)) {
            throw new IllegalArgumentException("Not a canonical value: " + value);
        }
        this.lineNumber = lineNumber;
        this.value = value;
        this.comments = comments;
    }

    @Pure
    public @NonNull Object getValue() {
        return this.value;
    }

    public @NonNull DataEntry withValue(@NonNull Object value) {
        return new DataEntry(value, this.lineNumber, this.comments);
    }

    public @NonNull DataEntry withLineNumber(int lineNumber) {
        return new DataEntry(this.value, lineNumber, this.comments);
    }

    public @NonNull DataEntry clearLineNumber() {
        return this.lineNumber == null ? this : new DataEntry(this.value, null, this.comments);
    }

    @Pure
    public @Nullable Integer getLineNumber() {
        return this.lineNumber;
    }

    public @NonNull DataEntry withComments(@NonNull CommentData comments) {
        return new DataEntry(this.value, this.lineNumber, comments);
    }

    public @NonNull DataEntry withComments(@NonNull CommentLocation location, @NonNull List<@NonNull String> lines) {
        return this.withComments(this.comments.setAt(location, lines));
    }

    @Pure
    public @NonNull CommentData getComments() {
        return this.comments;
    }

    public @NonNull List<@NonNull String> getComments(@NonNull CommentLocation location) {
        return this.comments.getAt(location);
    }

    DataEntry intoMutDeep() {
        if (this.value instanceof DataTree.Immut) {
            return this.withValue(((DataTree)this.value).intoMut());
        }
        if (this.value instanceof DataList.Immut) {
            return this.withValue(((DataList)this.value).intoMut());
        }
        return this;
    }

    DataEntry intoImmutDeep() {
        if (this.value instanceof DataTree.Mut) {
            return this.withValue(((DataTree)this.value).intoImmut());
        }
        if (this.value instanceof DataList.Mut) {
            return this.withValue(((DataList)this.value).intoImmut());
        }
        return this;
    }

    public boolean equals(Object obj) {
        return obj instanceof DataEntry && this.value.equals(((DataEntry)obj).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return DataToString.implToString(this);
    }

    void toString(DataToString.Scope output) {
        output.append(this.getClass().getSimpleName());
        output.append('{');
        output.append("value=");
        output.valueToString(this.value);
        if (this.lineNumber != null) {
            output.append(',');
            output.append(' ');
            output.append("lineNumber=");
            output.append(this.lineNumber.toString());
        }
        if (!this.comments.isEmpty()) {
            output.append(',');
            output.append(' ');
            output.append("comments=");
            this.comments.toString(output);
        }
        output.append('}');
    }

    public static boolean validateValue(@Nullable Object value) {
        return value instanceof DataTree || value instanceof DataList || DataTree.validateKey(value);
    }
}

