/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Backend;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.CommentData;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataList;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.CommentLocation;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;

record Comparison(Backend.Document subject, Backend.Document reloaded, Backend.Meta backendMeta) {
    private String errorMsg(String msg) {
        String errorMsg = "Wrote data tree \n" + String.valueOf(this.subject.data()) + "\n and reloaded it to \n" + String.valueOf(this.reloaded.data()) + ".\n But failed because of " + msg;
        if (!this.subject.comments().isEmpty()) {
            errorMsg = errorMsg + ". Note that document comments were added: " + String.valueOf(this.subject.comments());
        }
        return errorMsg;
    }

    private AssertionError error(String msg) {
        throw new AssertionError((Object)this.errorMsg(msg));
    }

    private AssertionError error(String msg, Error cause) {
        throw new AssertionError(this.errorMsg(msg), cause);
    }

    void treesEqual(DataTree fromLibrary, DataTree fromBackend) {
        if (fromLibrary.size() != fromBackend.size()) {
            throw this.error("Wrong size " + String.valueOf(fromLibrary) + " vs " + String.valueOf(fromBackend));
        }
        Map<String, DataEntry> fromLibraryMap = fromLibrary.keySet().stream().map(key -> Map.entry(key.toString(), fromLibrary.get(key))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, DataEntry> fromBackendMap = fromBackend.keySet().stream().map(key -> Map.entry(key.toString(), fromBackend.get(key))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Assertions.assertEquals(fromLibraryMap.keySet(), fromBackendMap.keySet());
        fromLibraryMap.forEach((key, entry) -> {
            DataEntry corresponding = (DataEntry)fromBackendMap.get(key);
            try {
                this.entriesEqual((DataEntry)entry, corresponding);
            }
            catch (AssertionError ex) {
                throw this.error("Failed at key " + key, (Error)((Object)ex));
            }
        });
    }

    void entriesEqual(DataEntry fromLibrary, DataEntry fromBackend) {
        Object backendValue;
        Object libraryValue;
        block8: {
            DataList backendList;
            DataList libraryList;
            block10: {
                block9: {
                    libraryValue = fromLibrary.getValue();
                    backendValue = fromBackend.getValue();
                    if (libraryValue instanceof DataTree) {
                        DataTree libraryTree = (DataTree)libraryValue;
                        if (!(backendValue instanceof DataTree)) {
                            throw this.error("Expected DataTree, but got " + String.valueOf(backendValue));
                        }
                        DataTree backendTree = (DataTree)backendValue;
                        this.treesEqual(libraryTree, backendTree);
                        return;
                    }
                    if (!(libraryValue instanceof DataList)) break block8;
                    libraryList = (DataList)libraryValue;
                    if (!(backendValue instanceof DataList)) break block9;
                    backendList = (DataList)backendValue;
                    if (libraryList.size() == backendList.size()) break block10;
                }
                throw this.error("Not a list " + String.valueOf(backendValue) + ", expected " + String.valueOf(libraryList));
            }
            for (int n = 0; n < libraryList.size(); ++n) {
                this.entriesEqual(libraryList.get(n), backendList.get(n));
            }
            return;
        }
        if (libraryValue instanceof Float || libraryValue instanceof Double) {
            Assertions.assertTrue(((backendValue instanceof Float || backendValue instanceof Double) && Comparison.equalsDegreeOfAccuracy(((Number)libraryValue).doubleValue(), ((Number)backendValue).doubleValue()) ? 1 : 0) != 0, (String)("Expected " + String.valueOf(libraryValue) + " but got " + String.valueOf(backendValue)));
        } else {
            Assertions.assertEquals((Object)libraryValue.toString(), (Object)backendValue.toString());
        }
        this.commentsEqual(false, fromLibrary.getComments(), fromBackend.getComments());
    }

    void headerFooterEqual(Backend.Document fromLibrary, Backend.Document fromBackend) {
        try {
            this.commentsEqual(true, fromLibrary.comments(), fromBackend.comments());
        }
        catch (AssertionError ex) {
            throw this.error("Document-level comments became " + String.valueOf(fromBackend.comments()), (Error)((Object)ex));
        }
    }

    private void commentsEqual(boolean documentLevel, CommentData fromLibrary, CommentData fromBackend) {
        for (CommentLocation commentLocation : CommentLocation.values()) {
            if (!this.backendMeta.supportsComments(documentLevel, true, commentLocation)) continue;
            Assertions.assertEquals(fromLibrary.getAt(commentLocation), fromBackend.getAt(commentLocation));
        }
    }

    private static boolean equalsDegreeOfAccuracy(double val1, double val2) {
        double epsilon = 1.0E-5;
        return Math.abs(val1 - val2) < epsilon;
    }
}

