/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ImmutabilityGuard;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.CommentData;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.CommentLocation;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.Comments;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.ImmutableCollections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CommentDataTest {
    CommentDataTest() {
    }

    @Test
    public void setAt() {
        CommentData empty = CommentData.empty();
        try (ImmutGuard ignored = new ImmutGuard(empty, new CommentData[0]);){
            CommentData c1c2 = empty.setAt(CommentLocation.ABOVE, List.of("c1", "c2"));
            Assertions.assertEquals(List.of("c1", "c2"), c1c2.getAt(CommentLocation.ABOVE));
            Assertions.assertEquals(List.of(), c1c2.getAt(CommentLocation.INLINE));
        }
    }

    @Test
    public void isEmpty() {
        CommentData c1c2 = CommentData.empty().setAt(CommentLocation.ABOVE, List.of("c1", "c2"));
        Assertions.assertFalse((boolean)c1c2.isEmpty());
        Assertions.assertEquals(List.of("c1", "c2"), c1c2.getAt(CommentLocation.ABOVE), (String)"immutable");
    }

    @Test
    public void clearAt() {
        CommentData empty = CommentData.empty();
        CommentData c1c2 = empty.setAt(CommentLocation.ABOVE, List.of("c1", "c2"));
        try (ImmutGuard ignored = new ImmutGuard(empty, c1c2);){
            Assertions.assertEquals((Object)c1c2, (Object)c1c2.clearAt(CommentLocation.INLINE, CommentLocation.BELOW));
            Assertions.assertEquals((Object)c1c2, (Object)c1c2.clearAt(new CommentLocation[0]));
            Assertions.assertEquals((Object)c1c2, (Object)c1c2.clearAt(CommentLocation.INLINE));
            Assertions.assertEquals((Object)empty, (Object)c1c2.clearAt(CommentLocation.ABOVE));
            Assertions.assertEquals((Object)empty, (Object)c1c2.clearAt(CommentLocation.values()));
            Assertions.assertEquals((Object)empty, (Object)empty.clearAt(CommentLocation.values()));
            Assertions.assertEquals(List.of("c1", "c2"), c1c2.getAt(CommentLocation.ABOVE), (String)"immutable");
        }
    }

    @Test
    public void clearAtWithLeftover() {
        CommentData empty = CommentData.empty();
        CommentData c1c2 = empty.setAt(CommentLocation.ABOVE, List.of("c1", "c2"));
        CommentData greeting = c1c2.setAt(CommentLocation.INLINE, "hi");
        try (ImmutGuard ignored = new ImmutGuard(empty, c1c2, greeting);){
            Assertions.assertEquals((Object)greeting, (Object)greeting.clearAt(CommentLocation.BELOW));
            Assertions.assertEquals((Object)greeting, (Object)greeting.clearAt(new CommentLocation[0]));
            Assertions.assertEquals((Object)c1c2, (Object)greeting.clearAt(CommentLocation.INLINE));
            Assertions.assertEquals(List.of("hi"), greeting.clearAt(CommentLocation.ABOVE).getAt(CommentLocation.INLINE));
            Assertions.assertEquals((Object)empty, (Object)greeting.clearAt(CommentLocation.values()));
            Assertions.assertEquals(List.of("c1", "c2"), greeting.getAt(CommentLocation.ABOVE), (String)"immutable");
            Assertions.assertEquals(List.of("hi"), greeting.getAt(CommentLocation.INLINE), (String)"immutable");
        }
    }

    @Test
    public void clearAtViaSet() {
        CommentData empty = CommentData.empty();
        CommentData c1c2 = empty.setAt(CommentLocation.ABOVE, List.of("c1", "c2"));
        try (ImmutGuard ignored = new ImmutGuard(empty, c1c2);){
            Assertions.assertEquals((Object)c1c2, (Object)c1c2.setAt(CommentLocation.INLINE, List.of()));
            Assertions.assertEquals((Object)empty, (Object)c1c2.setAt(CommentLocation.ABOVE, List.of()));
            Assertions.assertEquals((Object)c1c2, (Object)c1c2.setAt(CommentLocation.INLINE, new String[0]));
            Assertions.assertEquals((Object)empty, (Object)c1c2.setAt(CommentLocation.ABOVE, new String[0]));
            Assertions.assertEquals(List.of("c1", "c2"), c1c2.getAt(CommentLocation.ABOVE), (String)"immutable");
        }
    }

    @Test
    public void append() {
        CommentData empty = CommentData.empty();
        CommentData below = empty.setAt(CommentLocation.BELOW, "b1", "b2");
        CommentData overlap = empty.setAt(CommentLocation.BELOW, "overlap").setAt(CommentLocation.INLINE, "untouched");
        try (ImmutGuard ignored = new ImmutGuard(empty, below, overlap);){
            Assertions.assertEquals((Object)empty.setAt(CommentLocation.BELOW, "b1", "b2", "overlap").setAt(CommentLocation.INLINE, "untouched"), (Object)below.append(overlap));
            Assertions.assertEquals((Object)empty.setAt(CommentLocation.BELOW, "overlap", "b1", "b2").setAt(CommentLocation.INLINE, "untouched"), (Object)overlap.append(below));
            Assertions.assertEquals(List.of(), below.append(overlap).getAt(CommentLocation.ABOVE));
            Assertions.assertEquals(List.of(), overlap.append(below).getAt(CommentLocation.ABOVE));
        }
    }

    @Test
    public void appendAt() {
        CommentData empty = CommentData.empty();
        CommentData c1c2 = empty.setAt(CommentLocation.ABOVE, List.of("c1", "c2"));
        try (ImmutGuard ignored = new ImmutGuard(empty, c1c2);){
            Assertions.assertEquals((Object)c1c2, (Object)empty.appendAt(CommentLocation.ABOVE, List.of("c1", "c2")));
            Assertions.assertSame((Object)c1c2, (Object)c1c2.appendAt(CommentLocation.INLINE, List.of()));
            List<String> inline = List.of("beside value");
            CommentData addInline = c1c2.appendAt(CommentLocation.INLINE, inline);
            Assertions.assertEquals(inline, addInline.getAt(CommentLocation.INLINE));
            Assertions.assertEquals(List.of(), addInline.getAt(CommentLocation.BELOW));
            CommentData combined = addInline.appendAt(CommentLocation.ABOVE, "to append");
            Assertions.assertEquals(List.of("c1", "c2", "to append"), combined.getAt(CommentLocation.ABOVE));
            Assertions.assertEquals(List.of(), combined.getAt(CommentLocation.BELOW));
        }
    }

    @Test
    public void empty() {
        CommentData empty = CommentData.empty();
        try (ImmutGuard ignored = new ImmutGuard(empty, new CommentData[0]);){
            Assertions.assertTrue((boolean)empty.isEmpty());
            for (CommentLocation location : CommentLocation.values()) {
                Assertions.assertEquals(List.of(), empty.getAt(location));
            }
            CommentData c1c2 = empty.setAt(CommentLocation.ABOVE, List.of("c1", "c2"));
            Assertions.assertEquals((Object)c1c2, (Object)empty.append(c1c2));
            Assertions.assertEquals((Object)c1c2, (Object)c1c2.append(empty));
            List<String> inline = List.of("beside value");
            CommentData addInline = empty.appendAt(CommentLocation.INLINE, inline);
            CommentData setInline = empty.setAt(CommentLocation.INLINE, inline);
            Assertions.assertEquals((Object)setInline, (Object)addInline);
            Assertions.assertEquals(setInline.getAt(CommentLocation.ABOVE), addInline.getAt(CommentLocation.ABOVE));
        }
    }

    @Test
    public void buildFrom() {
        Assertions.assertEquals((Object)CommentData.empty(), (Object)CommentData.buildFrom(new Comments[0]));
        @Comments.Container(value={@Comments(value={}, location=CommentLocation.INLINE), @Comments(value={}, location=CommentLocation.BELOW)})
        class Empty {
            Empty(CommentDataTest this$0) {
            }
        }
        Assertions.assertEquals((Object)CommentData.empty(), (Object)CommentData.buildFrom((Comments[])Empty.class.getAnnotationsByType(Comments.class)));
        @Comments.Container(value={@Comments(value={"inline1"}, location=CommentLocation.INLINE), @Comments(value={"line1", "line2"}), @Comments(value={"line3"}, location=CommentLocation.ABOVE), @Comments(value={}, location=CommentLocation.BELOW), @Comments(value={"inline2"}, location=CommentLocation.INLINE)})
        class TestOn {
            TestOn(CommentDataTest this$0) {
            }
        }
        Assertions.assertEquals((Object)CommentData.empty().setAt(CommentLocation.ABOVE, "line1", "line2", "line3").setAt(CommentLocation.INLINE, "inline1", "inline2"), (Object)CommentData.buildFrom((Comments[])TestOn.class.getAnnotationsByType(Comments.class)));
    }

    @Test
    public void equals() {
        EqualsVerifier.forClass(CommentData.class).verify();
    }

    @Test
    public void toStringTest() {
        Assertions.assertTrue((boolean)CommentData.empty().setAt(CommentLocation.ABOVE, "i love comments").toString().contains("love"));
    }

    static class ImmutGuard
    extends ImmutabilityGuard<CommentData, Map<CommentLocation, List<String>>> {
        ImmutGuard(CommentData value, CommentData ... extra) {
            super(value, extra);
        }

        @Override
        protected Map<CommentLocation, List<String>> takeSnapshot(CommentData value) {
            EnumMap<CommentLocation, List<String>> data = new EnumMap<CommentLocation, List<String>>(CommentLocation.class);
            for (CommentLocation location : CommentLocation.values()) {
                List<String> source = value.getAt(location);
                this.testImmutable(source, "dummy");
                data.put(location, ImmutableCollections.listOf(source));
            }
            return ImmutableCollections.mapOf(data);
        }
    }
}

