/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataToString;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.CommentLocation;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.Comments;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.ImmutableCollections;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CommentData {
    private final @NonNull Map<CommentLocation, List<String>> contents;
    static final CommentData EMPTY = new CommentData();

    CommentData(@NonNull Map<CommentLocation, List<String>> contents) {
        this.contents = contents;
    }

    private CommentData() {
        this.contents = ImmutableCollections.emptyMap();
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public @NonNull List<@NonNull String> getAt(@NonNull CommentLocation location) {
        return this.contents.getOrDefault((Object)location, ImmutableCollections.emptyList());
    }

    public @NonNull CommentData setAt(@NonNull CommentLocation location, @NonNull List<@NonNull String> lines) {
        if (lines.isEmpty()) {
            return this.clearAt(location);
        }
        EnumMap<CommentLocation, List<String>> newContents = new EnumMap<CommentLocation, List<String>>(CommentLocation.class);
        newContents.putAll(this.contents);
        newContents.put(location, ImmutableCollections.listOf(lines));
        return new CommentData(newContents);
    }

    public @NonNull CommentData setAt(@NonNull CommentLocation location, String ... lines) {
        return this.setAt(location, Arrays.asList(lines));
    }

    public @NonNull CommentData appendAt(@NonNull CommentLocation location, @NonNull List<@NonNull String> lines) {
        List<String> combined;
        if (lines.isEmpty()) {
            return this;
        }
        EnumMap<CommentLocation, List<String>> newContents = new EnumMap<CommentLocation, List<String>>(CommentLocation.class);
        newContents.putAll(this.contents);
        List existing = (List)newContents.get((Object)location);
        if (existing == null) {
            combined = ImmutableCollections.listOf(lines);
        } else {
            combined = new ArrayList<String>(existing.size() + lines.size());
            combined.addAll(existing);
            combined.addAll(lines);
            combined = ImmutableCollections.listOf(combined);
        }
        newContents.put(location, combined);
        return new CommentData(newContents);
    }

    public @NonNull CommentData appendAt(@NonNull CommentLocation location, String ... lines) {
        return this.appendAt(location, Arrays.asList(lines));
    }

    public @NonNull CommentData clearAt(CommentLocation ... locations) {
        boolean foundAny = false;
        for (CommentLocation location : locations) {
            foundAny = foundAny || this.contents.containsKey((Object)location);
        }
        if (!foundAny) {
            return this;
        }
        EnumMap<CommentLocation, List<String>> newContents = new EnumMap<CommentLocation, List<String>>(CommentLocation.class);
        newContents.putAll(this.contents);
        for (CommentLocation location : locations) {
            newContents.remove((Object)location);
        }
        if (newContents.isEmpty()) {
            return EMPTY;
        }
        return new CommentData(newContents);
    }

    public @NonNull CommentData append(@NonNull CommentData other) {
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        EnumMap<CommentLocation, List<String>> combined = new EnumMap<CommentLocation, List<String>>(CommentLocation.class);
        for (CommentLocation location : CommentLocation.values()) {
            List<String> combinedLines;
            List<String> ourLines = this.contents.get((Object)location);
            List<String> theirLines = other.contents.get((Object)location);
            if (ourLines == null && theirLines == null) continue;
            if (ourLines == null) {
                combinedLines = theirLines;
            } else if (theirLines == null) {
                combinedLines = ourLines;
            } else {
                combinedLines = new ArrayList<String>(ourLines.size() + theirLines.size());
                combinedLines.addAll(ourLines);
                combinedLines.addAll(theirLines);
                combinedLines = ImmutableCollections.listOf(combinedLines);
            }
            combined.put(location, combinedLines);
        }
        return new CommentData(combined);
    }

    public static @NonNull CommentData buildFrom(@NonNull Comments @Nullable [] source) {
        if (source == null || source.length == 0) {
            return EMPTY;
        }
        EnumMap<CommentLocation, List<String>> builtContents = new EnumMap<CommentLocation, List<String>>(CommentLocation.class);
        for (Comments comments : source) {
            CommentLocation location = comments.location();
            String[] value = comments.value();
            if (value.length == 0) continue;
            builtContents.computeIfAbsent(location, k -> new ArrayList(value.length)).addAll(Arrays.asList(value));
        }
        if (builtContents.isEmpty()) {
            return EMPTY;
        }
        for (CommentLocation commentLocation : CommentLocation.values()) {
            builtContents.computeIfPresent(commentLocation, (loc, lines) -> ImmutableCollections.listOf(lines));
        }
        return new CommentData(builtContents);
    }

    public static CommentData empty() {
        return EMPTY;
    }

    public boolean equals(Object obj) {
        return obj instanceof CommentData && this.contents.equals(((CommentData)obj).contents);
    }

    public int hashCode() {
        return this.contents.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.contents;
    }

    void toString(DataToString.Scope scope) {
        scope.append(this.contents.toString());
    }
}

