/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ErrorContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.TestingErrorSource;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Backend;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Comparison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.CountEntries;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.RandomGen;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.ReadableRoot;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.SimpleDocument;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.StringRoot;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;

public abstract class BackendTest {
    protected abstract Backend createBackend(ReadableRoot var1);

    @TestFactory
    public Stream<DynamicTest> readWriteRandomData() {
        ErrorContext.Source errorSource = new TestingErrorSource().makeErrorSource();
        AtomicInteger sizeRecord = new AtomicInteger();
        AtomicLong ratioRecord = new AtomicLong(Double.doubleToRawLongBits(0.0));
        return (Stream)Stream.generate(DataTree.Mut::new).limit(1000L).map(dataTree -> {
            StringRoot stringRoot = new StringRoot("");
            Backend backend = this.createBackend(stringRoot);
            CountEntries countEntries = new CountEntries();
            RandomGen randomGen = new RandomGen(backend.meta(), ThreadLocalRandom.current(), countEntries);
            randomGen.fillDataTree((DataTree.Mut)dataTree, 1, 0);
            SimpleDocument subject = new SimpleDocument(randomGen.generateDocumentComments(), dataTree.intoImmut());
            return DynamicTest.dynamicTest((String)("Using document " + String.valueOf(subject)), () -> {
                long compareRatioRecord;
                int compareSizeRecord;
                Assertions.assertDoesNotThrow(() -> backend.write(subject));
                int dataSize = stringRoot.readString().length();
                LoadResult reloadResult = (LoadResult)Assertions.assertDoesNotThrow(() -> backend.read(errorSource));
                Assertions.assertTrue((boolean)reloadResult.isSuccess(), () -> "Failed to re-read data \n" + String.valueOf(subject) + ". Document looks like:\n---\n" + stringRoot.readString());
                Backend.Document reloaded = (Backend.Document)reloadResult.getOrThrow();
                if (reloaded == null) {
                    Assertions.fail((String)("Reloaded document is null for input " + String.valueOf(subject) + ". Document looks like:\n---\n" + stringRoot.readString()));
                }
                Comparison comparison = new Comparison(subject, reloaded, backend.meta());
                comparison.headerFooterEqual(subject, reloaded);
                comparison.treesEqual(subject.data(), reloaded.data());
                double dataRatio = (double)dataSize / (double)countEntries.count;
                while (dataSize > (compareSizeRecord = sizeRecord.get()) && !sizeRecord.compareAndSet(compareSizeRecord, dataSize)) {
                }
                while (dataRatio > Double.longBitsToDouble(compareRatioRecord = ratioRecord.get()) && !ratioRecord.compareAndSet(compareRatioRecord, Double.doubleToRawLongBits(dataRatio))) {
                }
                if (dataRatio > 1000.0) {
                    Assertions.fail((String)"DATA RATIO ABOVE 1000!");
                }
            });
        }).onClose(() -> {
            System.out.println("Size record of " + sizeRecord.get() + " established.");
            System.out.println("Ratio record of " + Double.longBitsToDouble(ratioRecord.get()) + " established.");
        });
    }
}

