/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.DeveloperMistakeException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.CommentData;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.DefaultValues;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeDeserialize;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeOutput;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodId;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodMirror;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class TypeSkeleton {
    final MethodId[] callableDefaultMethods;
    final MethodNode<?>[] methodNodes;

    TypeSkeleton(Collection<MethodId> callableDefaultMethods, List<MethodNode<?>> methodNodes) {
        this.callableDefaultMethods = callableDefaultMethods.toArray(new MethodId[0]);
        this.methodNodes = methodNodes.toArray(new MethodNode[0]);
    }

    static final class MethodNode<V> {
        final CommentData comments;
        final boolean optional;
        final MethodId methodId;
        private final DefaultValues<V> defaultValues;
        final SerializeDeserialize<V> serializer;

        MethodNode(CommentData comments, boolean optional, MethodId methodId, DefaultValues<V> defaultValues, SerializeDeserialize<V> serializer) {
            this.comments = comments;
            this.optional = optional;
            this.methodId = Objects.requireNonNull(methodId, "methodId");
            this.defaultValues = defaultValues;
            this.serializer = Objects.requireNonNull(serializer, "serializer");
        }

        Object makeDefaultValue(Class<?> inType) {
            V defaultVal;
            if (this.defaultValues == null) {
                if (this.optional) {
                    return Optional.empty();
                }
                throw new DeveloperMistakeException("No default values configured for " + inType.getName() + '#' + this.methodId.name() + ". To use Configuration#loadDefaults, default values must be set for every option.");
            }
            try {
                defaultVal = this.defaultValues.defaultValue();
            }
            catch (RuntimeException ex) {
                throw new DeveloperMistakeException("DefaultValues#defaultValue threw an exception", ex);
            }
            if (defaultVal == null) {
                throw new DeveloperMistakeException("DefaultValues#defaultValue returned null for " + inType.getName() + '#' + this.methodId.name());
            }
            return this.optional ? Optional.of(defaultVal) : defaultVal;
        }

        V makeMissingValue(Class<?> inType) {
            assert (!this.optional) : "handled elsewhere";
            if (this.defaultValues == null) {
                return null;
            }
            V defaultVal = this.defaultValues.ifMissing();
            if (defaultVal == null) {
                throw new DeveloperMistakeException("DefaultValues#missingValue returned null for " + inType.getName() + '#' + this.methodId.name());
            }
            return defaultVal;
        }

        @Nullable DataEntry serialize(MethodMirror.Invoker invoker, SerializeOutput ser) {
            Object value;
            try {
                value = invoker.invokeMethod(this.methodId, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                throw new DeveloperMistakeException("Configuration methods must not throw exceptions", ex);
            }
            if (value == null) {
                throw new DeveloperMistakeException("Configuration method " + this.methodId + " must not return null");
            }
            if (this.optional && (value = ((Optional)value).orElse(null)) == null) {
                return null;
            }
            Object castValue = value;
            return this.serialize(castValue, ser);
        }

        @NonNull DataEntry serialize(V value, SerializeOutput ser) {
            this.serializer.serialize(value, ser);
            Object output = ser.getAndClearLastOutput();
            if (output == null) {
                throw new DeveloperMistakeException("Serializer " + this.serializer + " did not produce any output for " + value);
            }
            return new DataEntry(output);
        }
    }
}

