/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ErrorContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ErrorPrint;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyPath;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Printable;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.lang.LibraryLang;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class StandardErrorPrint
implements ErrorPrint {
    private final ErrorPrint.Output output;

    public StandardErrorPrint(@NonNull ErrorPrint.Output output) {
        this.output = Objects.requireNonNull(output);
    }

    @Override
    public void onError(final @NonNull List<@NonNull ErrorContext> errorContexts) {
        if (errorContexts.isEmpty()) {
            throw new IllegalArgumentException("Error context list is empty");
        }
        this.output.output(new Printable.Abstract(){

            @Override
            public void printTo(@NonNull Appendable output) throws IOException {
                LibraryLang lang = LibraryLang.Accessor.access((ErrorContext)errorContexts.get(0), ErrorContext::getLocale);
                output.append('\n');
                output.append(lang.errorIntro());
                output.append('\n');
                output.append(lang.errorContext());
                int errorCount = errorContexts.size();
                int cap = Integer.min(4, errorCount);
                for (int n = 0; n < cap; ++n) {
                    Integer lineNumber;
                    ErrorContext currentError = (ErrorContext)errorContexts.get(n);
                    output.append("\n  ");
                    boolean pathOrLineNumber = false;
                    KeyPath path = currentError.query(ErrorContext.ENTRY_PATH);
                    if (path != null && !path.isEmpty()) {
                        path.printTo(output);
                        pathOrLineNumber = true;
                    }
                    if ((lineNumber = currentError.query(ErrorContext.LINE_NUMBER)) != null) {
                        if (pathOrLineNumber) {
                            output.append(' ');
                            output.append('@');
                            output.append(' ');
                        }
                        output.append(lang.line());
                        output.append(' ');
                        output.append(Integer.toString(lineNumber));
                        pathOrLineNumber = true;
                    }
                    if (pathOrLineNumber) {
                        output.append(':');
                        output.append(' ');
                    }
                    currentError.mainMessage().printTo(output);
                    Printable backendMessage = currentError.query(ErrorContext.BACKEND_MESSAGE);
                    if (backendMessage == null) continue;
                    output.append(':');
                    output.append(' ');
                    backendMessage.printTo(output);
                    URL syntaxLinter = currentError.query(ErrorContext.SYNTAX_LINTER);
                    if (syntaxLinter == null) continue;
                    output.append("\n  ");
                    output.append(lang.syntaxInvalidPleaseTryAt(syntaxLinter));
                }
                if (cap != errorCount) {
                    output.append("\n  ");
                    output.append('(');
                    output.append('+');
                    output.append(lang.more(errorCount - cap));
                    output.append(')');
                }
                output.append('\n');
            }
        });
    }
}

