/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Configuration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ReloadShell;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.CallableFn;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReloadShellTest {
    @Test
    public void nullDelegate() {
        ReloadShell<Object> reloadShell = Configuration.defaultBuilder(Config.class).build().makeReloadShell(null);
        Assertions.assertNull(reloadShell.getCurrentDelegate());
        Config shell = reloadShell.getShell();
        Assertions.assertThrows(NullPointerException.class, shell::integral);
        Assertions.assertThrows(NullPointerException.class, () -> shell.compute(1));
    }

    @Test
    public void delegateTo() {
        Config delegate = new Config(this){

            @Override
            public int integral() {
                return 4;
            }

            @Override
            public int compute(int value) {
                return 5 * value;
            }
        };
        ReloadShell<Config> reloadShell = Configuration.defaultBuilder(Config.class).build().makeReloadShell(delegate);
        Assertions.assertEquals((Object)delegate, (Object)reloadShell.getCurrentDelegate());
        Config shell = reloadShell.getShell();
        Assertions.assertEquals((int)4, (int)shell.integral());
        Assertions.assertEquals((int)20, (int)shell.compute(4));
    }

    @Test
    public void swap() {
        Config first = () -> 4;
        Config second = () -> 5;
        ReloadShell<Object> reloadShell = Configuration.defaultBuilder(Config.class).build().makeReloadShell(null);
        Config shell = reloadShell.getShell();
        reloadShell.setCurrentDelegate(first);
        Assertions.assertDoesNotThrow(() -> reloadShell.setCurrentDelegate(first));
        Assertions.assertSame((Object)first, reloadShell.getCurrentDelegate());
        Assertions.assertEquals((int)4, (int)shell.integral());
        Assertions.assertEquals((int)1, (int)shell.compute(0));
        reloadShell.setCurrentDelegate(second);
        Assertions.assertSame((Object)second, reloadShell.getCurrentDelegate());
        Assertions.assertEquals((int)5, (int)shell.integral());
        Assertions.assertEquals((int)1, (int)shell.compute(0));
    }

    public static interface Config {
        public int integral();

        @CallableFn
        default public int compute(int value) {
            return value + 1;
        }
    }
}

