/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Configuration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OptionalTest {
    @Test
    public void loadDefaults() {
        Config defaults = (Config)Configuration.defaultBuilder(Config.class).build().loadDefaults();
        Assertions.assertEquals(Optional.of("present"), defaults.presentByDefault());
        Assertions.assertEquals(Optional.empty(), defaults.missingByDefault());
    }

    @Test
    public void loadMissingValues() {
        Configuration<Config> config = Configuration.defaultBuilder(Config.class).build();
        Config loaded = config.readFrom(new DataTree.Immut()).getOrThrow();
        Assertions.assertEquals(Optional.empty(), loaded.presentByDefault());
        Assertions.assertEquals(Optional.empty(), loaded.missingByDefault());
    }

    @Test
    public void loadPresentValue() {
        Configuration<Config> config = Configuration.defaultBuilder(Config.class).build();
        DataTree.Mut dataTree = new DataTree.Mut();
        dataTree.put("missingByDefault", new DataEntry("set here"));
        Config loaded = config.readFrom(dataTree).getOrThrow();
        Assertions.assertEquals(Optional.empty(), loaded.presentByDefault());
        Assertions.assertEquals(Optional.of("set here"), loaded.missingByDefault());
    }

    @Test
    public void writePresentValue() {
        Configuration<Config> config = Configuration.defaultBuilder(Config.class).build();
        DataTree.Mut output = new DataTree.Mut();
        config.writeTo(new Config(this){

            @Override
            public Optional<String> presentByDefault() {
                return Optional.empty();
            }

            @Override
            public Optional<String> missingByDefault() {
                return Optional.of("set here");
            }
        }, output);
        Assertions.assertNull((Object)output.get("presentByDefault"));
        Assertions.assertEquals((Object)new DataEntry("set here"), (Object)output.get("missingByDefault"));
        DataTree.Mut expected = new DataTree.Mut();
        expected.put("missingByDefault", new DataEntry("set here"));
        Assertions.assertEquals((Object)expected, (Object)output);
    }

    public static interface Config {
        default public Optional<String> presentByDefault() {
            return Optional.of("present");
        }

        default public Optional<String> missingByDefault() {
            return Optional.empty();
        }
    }
}

