/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigurationDefinition;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ModifyComments;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.CommentData;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.CommentLocation;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.Comments;
import java.lang.reflect.Method;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class ModifyCommentsTest {
    private DataEntry dataEntry;
    private final ConfigurationDefinition.WriteOptions writeOptions;

    public ModifyCommentsTest(@Mock ConfigurationDefinition.WriteOptions writeOptions) {
        this.writeOptions = writeOptions;
    }

    @BeforeEach
    public void setupValue() {
        this.dataEntry = new DataEntry("initial value");
    }

    private static CommentData getComments(String methodName) {
        Method method;
        try {
            method = ModifyCommentsTest.class.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        return CommentData.buildFrom((Comments[])method.getAnnotationsByType(Comments.class));
    }

    @Test
    @Comments.Container(value={@Comments(value={"Hi there", "Another on top"}), @Comments(value={"From below"}, location=CommentLocation.BELOW)})
    public void copyAllComments() {
        Mockito.when((Object)this.writeOptions.writeEntryComments((CommentLocation)((Object)ArgumentMatchers.any()))).thenReturn((Object)true);
        ModifyComments modifyComments = new ModifyComments(this.writeOptions);
        Assertions.assertTrue((boolean)modifyComments.writeEntryComments(CommentLocation.ABOVE));
        Assertions.assertTrue((boolean)modifyComments.writeEntryComments(CommentLocation.INLINE));
        Assertions.assertTrue((boolean)modifyComments.writeEntryComments(CommentLocation.BELOW));
        Assertions.assertTrue((boolean)modifyComments.isAnyLocationEnabled());
        CommentData copyFrom = ModifyCommentsTest.getComments("copyAllComments");
        this.dataEntry = modifyComments.applyTo(this.dataEntry, copyFrom);
        Assertions.assertEquals((Object)copyFrom, (Object)this.dataEntry.getComments());
    }

    @Test
    public void dontCopyAnything() {
        ModifyComments modifyComments = new ModifyComments(this.writeOptions);
        Assertions.assertFalse((boolean)modifyComments.writeEntryComments(CommentLocation.ABOVE));
        Assertions.assertFalse((boolean)modifyComments.writeEntryComments(CommentLocation.INLINE));
        Assertions.assertFalse((boolean)modifyComments.writeEntryComments(CommentLocation.BELOW));
        Assertions.assertFalse((boolean)modifyComments.isAnyLocationEnabled());
        this.dataEntry = modifyComments.applyTo(this.dataEntry, ModifyCommentsTest.getComments("copyAllComments"));
        Assertions.assertEquals((Object)CommentData.empty(), (Object)this.dataEntry.getComments());
    }

    @Test
    @Comments(value={"Existing comments not erased"})
    public void dontCopyDontOverwrite() {
        ModifyComments modifyComments = new ModifyComments(this.writeOptions);
        Assertions.assertFalse((boolean)modifyComments.writeEntryComments(CommentLocation.ABOVE));
        Assertions.assertFalse((boolean)modifyComments.writeEntryComments(CommentLocation.INLINE));
        Assertions.assertFalse((boolean)modifyComments.writeEntryComments(CommentLocation.BELOW));
        Assertions.assertFalse((boolean)modifyComments.isAnyLocationEnabled());
        CommentData existingData = ModifyCommentsTest.getComments("dontCopyDontOverwrite");
        this.dataEntry = this.dataEntry.withComments(existingData);
        this.dataEntry = modifyComments.applyTo(this.dataEntry, ModifyCommentsTest.getComments("copyAllComments"));
        Assertions.assertEquals((Object)existingData, (Object)this.dataEntry.getComments());
    }

    @Test
    @Comments.Container(value={@Comments(value={"Hi there"}), @Comments(value={"Inline should not be copied"}, location=CommentLocation.INLINE), @Comments(value={"From below"}, location=CommentLocation.BELOW)})
    public void setOnlyRequested() {
        Mockito.when((Object)this.writeOptions.writeEntryComments(CommentLocation.ABOVE)).thenReturn((Object)true);
        Mockito.when((Object)this.writeOptions.writeEntryComments(CommentLocation.BELOW)).thenReturn((Object)true);
        ModifyComments modifyComments = new ModifyComments(this.writeOptions);
        Assertions.assertTrue((boolean)modifyComments.writeEntryComments(CommentLocation.ABOVE));
        Assertions.assertFalse((boolean)modifyComments.writeEntryComments(CommentLocation.INLINE));
        Assertions.assertTrue((boolean)modifyComments.writeEntryComments(CommentLocation.BELOW));
        Assertions.assertTrue((boolean)modifyComments.isAnyLocationEnabled());
        CommentData copyFrom = ModifyCommentsTest.getComments("setOnlyRequested");
        this.dataEntry = modifyComments.applyTo(this.dataEntry, copyFrom);
        Assertions.assertEquals((Object)CommentData.empty().setAt(CommentLocation.ABOVE, "Hi there").setAt(CommentLocation.BELOW, "From below"), (Object)this.dataEntry.getComments());
    }

    @Test
    @Comments.Container(value={@Comments(value={"Please overwrite me", "another line"}), @Comments(value={"But not me"}, location=CommentLocation.INLINE)})
    public void overwriteExisting() {
        Mockito.when((Object)this.writeOptions.writeEntryComments(CommentLocation.ABOVE)).thenReturn((Object)true);
        Mockito.when((Object)this.writeOptions.writeEntryComments(CommentLocation.BELOW)).thenReturn((Object)true);
        ModifyComments modifyComments = new ModifyComments(this.writeOptions);
        Assertions.assertTrue((boolean)modifyComments.writeEntryComments(CommentLocation.ABOVE));
        Assertions.assertFalse((boolean)modifyComments.writeEntryComments(CommentLocation.INLINE));
        Assertions.assertTrue((boolean)modifyComments.writeEntryComments(CommentLocation.BELOW));
        Assertions.assertTrue((boolean)modifyComments.isAnyLocationEnabled());
        CommentData existingData = ModifyCommentsTest.getComments("overwriteExisting");
        this.dataEntry = this.dataEntry.withComments(existingData);
        CommentData overwriteWith = CommentData.empty().setAt(CommentLocation.ABOVE, "Hi there").setAt(CommentLocation.BELOW, "From below");
        this.dataEntry = modifyComments.applyTo(this.dataEntry, overwriteWith);
        Assertions.assertEquals((Object)CommentData.empty().setAt(CommentLocation.ABOVE, "Hi there").setAt(CommentLocation.INLINE, "But not me").setAt(CommentLocation.BELOW, "From below"), (Object)this.dataEntry.getComments());
    }

    @AfterEach
    public void valueUnchanged() {
        Assertions.assertEquals((Object)"initial value", (Object)this.dataEntry.getValue());
    }
}

