/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigurationDefinition;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.CommentData;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.CommentLocation;

final class ModifyComments {
    private static final CommentLocation[] commentLocations = CommentLocation.values();
    private final boolean[] writeEntryComments;
    private final boolean writeAllEntryComments;

    ModifyComments(ConfigurationDefinition.WriteOptions initFrom) {
        boolean[] writeEntryComments = new boolean[commentLocations.length];
        for (int n = 0; n < writeEntryComments.length; ++n) {
            writeEntryComments[n] = initFrom.writeEntryComments(commentLocations[n]);
        }
        boolean writeAllEntryComments = writeEntryComments[0] && writeEntryComments[1] && writeEntryComments[2];
        this.writeEntryComments = writeEntryComments;
        this.writeAllEntryComments = writeAllEntryComments;
    }

    boolean writeEntryComments(CommentLocation location) {
        return this.writeAllEntryComments || this.writeEntryComments[location.ordinal()];
    }

    boolean isAnyLocationEnabled() {
        return this.writeAllEntryComments || this.writeEntryComments[0] || this.writeEntryComments[1] || this.writeEntryComments[2];
    }

    CommentData applyTo(CommentData original, CommentData sourceFrom) {
        if (this.writeAllEntryComments) {
            return sourceFrom;
        }
        for (CommentLocation location : commentLocations) {
            if (!this.writeEntryComments[location.ordinal()]) continue;
            original = original.setAt(location, sourceFrom.getAt(location));
        }
        return original;
    }

    DataEntry applyTo(DataEntry subject, CommentData sourceFrom) {
        return subject.withComments(this.applyTo(subject.getComments(), sourceFrom));
    }
}

