/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Configuration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigureListener;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ErrorContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.MatchDocumentData;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Backend;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DefaultKeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyPath;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.UpdateReason;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.StringDefault;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.migration.MigrateContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.migration.MigrateSource;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.migration.Migration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.migration.Transition;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatcher;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class MigrationTest {
    private final Backend backend;

    public MigrationTest(@Mock Backend backend) {
        this.backend = backend;
    }

    @BeforeEach
    public void setKeyMapper() {
        Mockito.when((Object)this.backend.recommendKeyMapper()).thenReturn((Object)new DefaultKeyMapper());
    }

    @Test
    public void migrate(@Mock ConfigureListener configureListener) {
        final AtomicInteger runs = new AtomicInteger();
        Migration<String, Destination> migration = new Migration<String, Destination>(new MigrateSource<String>(this){

            @Override
            public @NonNull LoadResult<@NonNull String> load(@NonNull MigrateContext migrateContext) {
                DataTree dataTree = migrateContext.mainBackend().read(migrateContext.errorSource()).getOrThrow().data();
                DataEntry oldHello = dataTree.get("old-hello");
                Assertions.assertNotNull((Object)oldHello);
                return LoadResult.of((String)oldHello.getValue());
            }

            @Override
            public void onCompletion() {
                runs.getAndIncrement();
            }

            @Override
            public @NonNull MigrateSource<String> addFilter(@NonNull MigrateSource.Filter<String> filter) {
                throw new UnsupportedOperationException();
            }
        }, (previous, migrateContext) -> {
            migrateContext.notifyUpdate(new KeyPath.Immut("affirmative"), UpdateReason.MIGRATED);
            return new Destination(){
                final /* synthetic */ String val$previous;
                {
                    this.val$previous = string;
                }

                @Override
                public String hello() {
                    return this.val$previous;
                }

                @Override
                public char affirmative() {
                    return 'W';
                }
            };
        });
        Configuration<Destination> config = Configuration.defaultBuilder(Destination.class).addMigration(migration).build();
        DataTree.Mut sourceTree = new DataTree.Mut();
        sourceTree.put("version", new DataEntry("old"));
        sourceTree.put("old-hello", new DataEntry("old-goodbye"));
        Mockito.when(this.backend.read((ErrorContext.Source)Mockito.any())).thenReturn(LoadResult.of(Backend.Document.simple(sourceTree)));
        Destination migrated = config.configureWith(this.backend).getOrThrow();
        Assertions.assertEquals((Object)"old-goodbye", (Object)migrated.hello());
        Assertions.assertEquals((char)'W', (char)migrated.affirmative());
        Assertions.assertEquals((int)1, (int)runs.get());
        Destination again = config.configureWith(this.backend, configureListener).getOrThrow();
        Assertions.assertEquals((Object)"old-goodbye", (Object)again.hello());
        Assertions.assertEquals((char)'W', (char)again.affirmative());
        Assertions.assertEquals((int)2, (int)runs.get());
        ((ConfigureListener)Mockito.verify((Object)configureListener)).migratedFrom(migration);
        ((ConfigureListener)Mockito.verify((Object)configureListener)).notifyUpdate(new KeyPath.Immut("affirmative"), UpdateReason.MIGRATED);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{configureListener});
    }

    @Test
    public void migrateNotApplicable(final @Mock ErrorContext dummyError, @Mock Transition<String, Destination> dummyTransition, @Mock ConfigureListener configureListener) {
        Migration<String, Destination> migration = new Migration<String, Destination>(new MigrateSource<String>(this){

            @Override
            public @NonNull LoadResult<@NonNull String> load(@NonNull MigrateContext migrateContext) {
                return LoadResult.failure(dummyError);
            }

            @Override
            public void onCompletion() {
                throw new AssertionError((Object)"Does not complete");
            }

            @Override
            public @NonNull MigrateSource<String> addFilter(@NonNull MigrateSource.Filter<String> filter) {
                throw new UnsupportedOperationException();
            }
        }, dummyTransition);
        Configuration<Destination> config = Configuration.defaultBuilder(Destination.class).addMigration(migration).build();
        Mockito.when(this.backend.read((ErrorContext.Source)Mockito.any())).thenReturn(LoadResult.of(null));
        Destination defaultValues = config.configureWith(this.backend, configureListener).getOrThrow();
        Assertions.assertEquals((Object)"goodbye", (Object)defaultValues.hello());
        Assertions.assertEquals((char)'y', (char)defaultValues.affirmative());
        ((ConfigureListener)Mockito.verify((Object)configureListener)).migrationSkip(migration, List.of(dummyError));
        ((ConfigureListener)Mockito.verify((Object)configureListener)).wroteDefaults();
        Mockito.verifyNoInteractions((Object[])new Object[]{dummyTransition});
    }

    @Test
    public void multipleApplicable(final @Mock ErrorContext dummyError, @Mock Transition<String, Destination> dummyTransition, @Mock ConfigureListener configureListener) {
        Migration<String, Destination> skipMigration = new Migration<String, Destination>(new MigrateSource<String>(this){

            @Override
            public @NonNull LoadResult<@NonNull String> load(@NonNull MigrateContext migrateContext) {
                return LoadResult.failure(dummyError);
            }

            @Override
            public void onCompletion() {
                throw new AssertionError((Object)"Does not complete");
            }

            @Override
            public @NonNull MigrateSource<String> addFilter(@NonNull MigrateSource.Filter<String> filter) {
                throw new UnsupportedOperationException();
            }
        }, dummyTransition);
        Migration<String, Destination> firstApplicable = new Migration<String, Destination>(new MigrateSource<String>(this){

            @Override
            public @NonNull LoadResult<@NonNull String> load(@NonNull MigrateContext migrateContext) {
                DataTree dataTree = migrateContext.mainBackend().read((ErrorContext.Source)Mockito.any()).getOrThrow().data();
                DataEntry oldHello = dataTree.get("old-hello");
                Assertions.assertNotNull((Object)oldHello);
                return LoadResult.of(String.valueOf(oldHello.getValue()) + "-first");
            }

            @Override
            public void onCompletion() {
            }

            @Override
            public @NonNull MigrateSource<String> addFilter(@NonNull MigrateSource.Filter<String> filter) {
                throw new UnsupportedOperationException();
            }
        }, ((Transition<String, String>)(previous, migrateContext) -> previous + "-chain").chain((previous, migrateContext) -> new Destination(){
            final /* synthetic */ String val$previous;
            {
                this.val$previous = string;
            }

            @Override
            public String hello() {
                return this.val$previous;
            }

            @Override
            public char affirmative() {
                return '1';
            }
        }));
        Migration<String, Destination> secondApplicable = new Migration<String, Destination>(new MigrateSource<String>(this){

            @Override
            public @NonNull LoadResult<@NonNull String> load(@NonNull MigrateContext migrateContext) {
                DataTree dataTree = migrateContext.mainBackend().read((ErrorContext.Source)Mockito.any()).getOrThrow().data();
                DataEntry oldHello = dataTree.get("old-hello");
                Assertions.assertNotNull((Object)oldHello);
                return LoadResult.of(String.valueOf(oldHello.getValue()) + "-second");
            }

            @Override
            public void onCompletion() {
            }

            @Override
            public @NonNull MigrateSource<String> addFilter(@NonNull MigrateSource.Filter<String> filter) {
                throw new UnsupportedOperationException();
            }
        }, (previous, migrateContext) -> new Destination(){
            final /* synthetic */ String val$previous;
            {
                this.val$previous = string;
            }

            @Override
            public String hello() {
                return this.val$previous;
            }

            @Override
            public char affirmative() {
                return '2';
            }
        });
        Configuration<Destination> config = Configuration.defaultBuilder(Destination.class).addMigration(skipMigration).addMigrations(List.of(firstApplicable, secondApplicable)).build();
        Assertions.assertEquals(List.of(skipMigration, firstApplicable, secondApplicable), config.getMigrations());
        DataTree.Mut sourceTree = new DataTree.Mut();
        sourceTree.put("version", new DataEntry("old"));
        sourceTree.put("old-hello", new DataEntry("old-goodbye"));
        Mockito.when(this.backend.read((ErrorContext.Source)Mockito.any())).thenReturn(LoadResult.of(Backend.Document.simple(sourceTree)));
        Destination migrated = config.configureWith(this.backend, configureListener).getOrThrow();
        Assertions.assertEquals((Object)"old-goodbye-first-chain", (Object)migrated.hello());
        Assertions.assertEquals((char)'1', (char)migrated.affirmative());
        ((ConfigureListener)Mockito.verify((Object)configureListener)).migrationSkip(skipMigration, List.of(dummyError));
        ((ConfigureListener)Mockito.verify((Object)configureListener)).migratedFrom(firstApplicable);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{configureListener});
        DataTree.Mut expectedWriteBack = new DataTree.Mut();
        expectedWriteBack.put("hello", new DataEntry("old-goodbye-first-chain"));
        expectedWriteBack.put("affirmative", new DataEntry(Character.valueOf('1')));
        ((Backend)Mockito.verify((Object)this.backend)).write((Backend.Document)Mockito.argThat((ArgumentMatcher)new MatchDocumentData(expectedWriteBack)));
    }

    public static interface Destination {
        @StringDefault(value="goodbye", ifMissing="goodbye-default-if-missing")
        public String hello();

        default public char affirmative() {
            return 'y';
        }
    }
}

