/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ErrorContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Printable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class LoadResultTest {
    @Test
    public void success() {
        LoadResult<String> loadResult = LoadResult.of("datum");
        Assertions.assertTrue((boolean)loadResult.isSuccess());
        Assertions.assertFalse((boolean)loadResult.isFailure());
        Assertions.assertEquals((Object)"datum", (Object)loadResult.getValue());
        Assertions.assertEquals((Object)"datum", (Object)loadResult.getOrThrow());
        Assertions.assertThrows(NoSuchElementException.class, loadResult::getErrorContexts);
        Assertions.assertTrue((boolean)loadResult.toString().contains("datum"));
        LoadResult<Integer> mapped = loadResult.map(String::length);
        Assertions.assertTrue((boolean)mapped.isSuccess());
        Assertions.assertEquals((int)5, (Integer)mapped.getOrThrow());
        LoadResult flatMapped = loadResult.flatMap(s -> LoadResult.of(s.length() + 1));
        Assertions.assertTrue((boolean)flatMapped.isSuccess());
        Assertions.assertEquals((int)6, (Integer)((Integer)flatMapped.getOrThrow()));
        LoadResult flatMappedError = loadResult.flatMap(s -> LoadResult.failure(List.of()));
        Assertions.assertFalse((boolean)flatMappedError.isSuccess());
    }

    @Test
    public void successNullable() {
        LoadResult<Object> loadResult = LoadResult.of(null);
        Assertions.assertTrue((boolean)loadResult.isSuccess());
        Assertions.assertFalse((boolean)loadResult.isFailure());
        Assertions.assertNull(loadResult.getValue());
        Assertions.assertNull(loadResult.getOrThrow());
        Assertions.assertThrows(NoSuchElementException.class, loadResult::getErrorContexts);
        Assertions.assertTrue((boolean)loadResult.toString().contains("null"));
        LoadResult<Boolean> mapped = loadResult.map(Objects::isNull);
        Assertions.assertTrue((boolean)mapped.isSuccess());
        Assertions.assertTrue((boolean)mapped.getOrThrow());
    }

    @Test
    public void failure(@Mock ErrorContext dummyErrorOne, @Mock ErrorContext dummyErrorTwo) {
        Mockito.lenient().when((Object)dummyErrorOne.display()).thenReturn((Object)Printable.preBuilt("failed for abc"));
        Mockito.lenient().when((Object)dummyErrorTwo.display()).thenReturn((Object)Printable.preBuilt("failed for xyz"));
        LoadResult<String> loadResult = LoadResult.failure(dummyErrorOne, dummyErrorTwo);
        Assertions.assertFalse((boolean)loadResult.isSuccess());
        Assertions.assertTrue((boolean)loadResult.isFailure());
        Assertions.assertNull(loadResult.getValue());
        Assertions.assertEquals(List.of(dummyErrorOne, dummyErrorTwo), loadResult.getErrorContexts());
        Assertions.assertTrue((boolean)loadResult.toString().contains(dummyErrorOne.toString()));
        NoSuchElementException nse = (NoSuchElementException)Assertions.assertThrows(NoSuchElementException.class, loadResult::getOrThrow);
        Assertions.assertTrue((boolean)nse.getMessage().contains("abc"));
        Assertions.assertTrue((boolean)nse.getMessage().contains("xyz"));
        LoadResult<Integer> mapped = loadResult.map(String::length);
        Assertions.assertFalse((boolean)mapped.isSuccess());
        LoadResult flatMapped = loadResult.flatMap(s -> LoadResult.of(s.length() + 1));
        Assertions.assertFalse((boolean)flatMapped.isSuccess());
        LoadResult flatMappedError = loadResult.flatMap(s -> LoadResult.failure(List.of()));
        Assertions.assertEquals(List.of(dummyErrorOne, dummyErrorTwo), flatMappedError.getErrorContexts());
    }

    @Test
    public void equality() {
        EqualsVerifier.forClass(LoadResult.class).verify();
    }
}

