/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ErrorContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.ImmutableCollections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class LoadResult<R> {
    private final Object value;
    private final boolean success;

    private LoadResult(Object value, boolean success) {
        this.value = value;
        this.success = success;
    }

    public static <R> @NonNull LoadResult<R> of(R success) {
        return new LoadResult<R>(success, true);
    }

    public static <R> @NonNull LoadResult<R> failure(ErrorContext ... reasons) {
        return new LoadResult<R>(ImmutableCollections.listOf(reasons), false);
    }

    public static <R> @NonNull LoadResult<R> failure(@NonNull List<@NonNull ErrorContext> reasons) {
        return new LoadResult<R>(ImmutableCollections.listOf(reasons), false);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isFailure() {
        return !this.success;
    }

    public @Nullable R getValue() {
        Object casted = this.success ? this.value : null;
        return (R)casted;
    }

    public @NonNull List<@NonNull ErrorContext> getErrorContexts() {
        if (this.success) {
            throw new NoSuchElementException("Error contexts not present (due to success)");
        }
        List contexts = (List)this.value;
        return contexts;
    }

    public <R_NEW> @NonNull LoadResult<R_NEW> map(Function<? super R, R_NEW> mapper) {
        if (this.success) {
            Object original = this.value;
            R_NEW updated = mapper.apply(original);
            return new LoadResult<R>(updated, true);
        }
        LoadResult casted = this;
        return casted;
    }

    public <R_NEW> @NonNull LoadResult<R_NEW> flatMap(Function<? super R, ? extends LoadResult<R_NEW>> mapper) {
        if (this.success) {
            Object original = this.value;
            return mapper.apply(original);
        }
        LoadResult casted = this;
        return casted;
    }

    public void ifSuccess(Consumer<? super R> action) {
        if (this.success) {
            action.accept(this.getValue());
        }
    }

    public R getOrThrow() {
        if (this.success) {
            return this.getValue();
        }
        StringBuilder exMsg = new StringBuilder("Success value not present");
        if (this.getErrorContexts().isEmpty()) {
            exMsg.append(" (empty error contexts)");
        } else {
            for (ErrorContext errorContext : this.getErrorContexts()) {
                exMsg.append('\n');
                errorContext.display().printTo(exMsg);
            }
        }
        throw new NoSuchElementException(exMsg.toString());
    }

    public boolean equals(Object o) {
        if (!(o instanceof LoadResult)) {
            return false;
        }
        LoadResult that = (LoadResult)o;
        return this.success == that.success && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.value);
        result = 31 * result + Boolean.hashCode(this.success);
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + (this.success ? this.value : "errors = " + this.getErrorContexts()) + '}';
    }
}

