/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ErrorContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Printable;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.lang.LibraryLang;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

final class LoadError
implements ErrorContext,
LibraryLang.Accessor {
    private final Printable message;
    private final LibraryLang libraryLang;
    private final Map<ErrorContext.Key<?>, Object> contexts = new LinkedHashMap();

    LoadError(Printable message, LibraryLang libraryLang) {
        this.message = Objects.requireNonNull(message, "message");
        this.libraryLang = Objects.requireNonNull(libraryLang, "libraryLang");
    }

    @Override
    public @NonNull LibraryLang getLibraryLang() {
        return this.libraryLang;
    }

    @Override
    public @NonNull Locale getLocale() {
        return this.libraryLang.getLocale();
    }

    @Override
    public @NonNull Printable mainMessage() {
        return this.message;
    }

    @Override
    public @NonNull Printable display() {
        return new Printable.Abstract(){

            @Override
            public void printTo(@NonNull Appendable output) throws IOException {
                output.append(LoadError.this.libraryLang.failed());
                output.append(':');
                output.append(' ');
                LoadError.this.message.printTo(output);
                for (ErrorContext.Key<?> key : LoadError.this.allKeys()) {
                    output.append("\n  ");
                    LoadError.this.formatKeyData(output, key);
                }
            }
        };
    }

    private <V> void formatKeyData(Appendable output, ErrorContext.Key<V> key) throws IOException {
        output.append(key.langKey.getMessage(this.libraryLang));
        output.append(": ");
        key.formatData.format(output, this.query(key));
    }

    @Override
    public <V> V query(@NonNull ErrorContext.Key<V> key) {
        Objects.requireNonNull(key, "key");
        Object value = this.contexts.get(key);
        return (V)value;
    }

    @Override
    public <V> void addDetail(@NonNull ErrorContext.Key<V> key, @NonNull V context) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(context, "context");
        this.contexts.put(key, context);
    }

    @Override
    public void clearDetail(@NonNull ErrorContext.Key<?> key) {
        this.contexts.remove(key);
    }

    @Override
    public void copyDetailsInto(@NonNull ErrorContext target) {
        for (ErrorContext.Key<?> key : this.contexts.keySet()) {
            this.copyContextInto(key, target);
        }
    }

    private <V> void copyContextInto(ErrorContext.Key<V> key, ErrorContext target) {
        V val = this.query(key);
        assert (val != null);
        target.addDetail(key, val);
    }

    @Override
    public @NonNull Set<@NonNull ErrorContext.Key<?>> allKeys() {
        return this.contexts.keySet();
    }

    static abstract class Factory
    implements ErrorContext.Source,
    LibraryLang.Accessor {
        Factory() {
        }

        @Override
        public @NonNull Locale getLocale() {
            return this.getLibraryLang().getLocale();
        }

        @Override
        public <R> @NonNull LoadResult<R> throwError(@NonNull CharSequence message) {
            return LoadResult.failure(this.buildError(Printable.preBuilt(message)));
        }

        @Override
        public <R> @NonNull LoadResult<R> throwError(@NonNull Printable message) {
            return LoadResult.failure(this.buildError(message));
        }
    }
}

