/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.DeveloperMistakeException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.TypeSkeleton;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.CommentData;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.Comments;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.DefaultValues;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeDeserialize;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.TypeLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodId;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodMirror;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.TypeToken;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class LiaisonCache {
    private final Map<TypeToken<?>, HandleType<?>> cachedAgents = new HashMap();
    private final TypeLiaison[] typeLiaisons;

    LiaisonCache(List<TypeLiaison> typeLiaisons) {
        this.typeLiaisons = typeLiaisons.toArray(new TypeLiaison[0]);
    }

    <V> HandleType<V> requestToHandle(TypeToken<V> typeToken, TypeLiaison.Handshake handshake) {
        HandleType<Object> cached = this.cachedAgents.get(typeToken);
        if (cached != null) {
            return cached;
        }
        for (int n = this.typeLiaisons.length - 1; n >= 0; --n) {
            TypeLiaison liaison = this.typeLiaisons[n];
            TypeLiaison.Agent<V> agent = liaison.makeAgent(typeToken, handshake);
            if (agent == null) continue;
            cached = new HandleType(typeToken, agent, agent.makeSerializer());
            this.cachedAgents.put(typeToken, cached);
            return cached;
        }
        throw new DeveloperMistakeException("Failed to resolve agent for " + typeToken + ". Please add a TypeLiaison or serializer for this type.");
    }

    static final class HandleType<V> {
        private final TypeToken<V> typeToken;
        private final TypeLiaison.Agent<V> agent;
        final SerializeDeserialize<V> serializer;

        private HandleType(TypeToken<V> typeToken, TypeLiaison.Agent<V> agent, SerializeDeserialize<V> serializer) {
            this.typeToken = typeToken;
            this.agent = agent;
            this.serializer = serializer;
        }

        TypeSkeleton.MethodNode<V> makeMethodNode(final MethodId methodId, final boolean optional, final AnnotatedElement methodAnnotations, final TypeToken<?> interfaceToken, final MethodMirror.Invoker defaultsInvoker) {
            TypeLiaison.DefaultInit defaultInit = new TypeLiaison.DefaultInit<V>(){

                @Override
                public @NonNull TypeToken<?> enclosingType() {
                    return interfaceToken;
                }

                @Override
                public @NonNull String label() {
                    return methodId.name();
                }

                @Override
                public @NonNull AnnotatedElement methodAnnotations() {
                    return methodAnnotations;
                }

                @Override
                public @Nullable DefaultValues<V> methodDefault() {
                    Object defaultVal;
                    if (!methodId.isDefault()) {
                        return null;
                    }
                    try {
                        defaultVal = defaultsInvoker.invokeMethod(methodId, new Object[0]);
                    }
                    catch (InvocationTargetException ex) {
                        throw new DeveloperMistakeException("Default method threw an exception", ex);
                    }
                    if (defaultVal == null) {
                        throw new DeveloperMistakeException("Default method " + methodId + " returned null");
                    }
                    if (optional) {
                        Optional optDefaultVal = (Optional)defaultVal;
                        if (optDefaultVal.isPresent()) {
                            defaultVal = optDefaultVal.get();
                        } else {
                            return null;
                        }
                    }
                    return DefaultValues.simple(typeToken.cast(defaultVal));
                }
            };
            DefaultValues<V> defaultValues = this.agent.loadDefaultValues(defaultInit);
            CommentData comments = CommentData.buildFrom((Comments[])methodAnnotations.getAnnotationsByType(Comments.class));
            return new TypeSkeleton.MethodNode<V>(comments, optional, methodId, defaultValues, this.serializer);
        }
    }
}

