/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Configuration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigurationDefinition;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.DeveloperMistakeException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataList;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DefaultKeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyPath;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.CallableFn;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.CommentLocation;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.UpdateListener;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.UpdateReason;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.IntegerDefault;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.support.ParameterDeclarations;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class InheritanceTest {
    @ParameterizedTest
    @ArgumentsSource(value=ClassProvider.class)
    public <C extends Grandparent> void inheritance(Class<C> type) {
        Configuration<C> configuration;
        try {
            configuration = Configuration.defaultBuilder(type).build();
        }
        catch (DeveloperMistakeException ex) {
            throw new AssertionError("Failed to load definition for " + String.valueOf(type), ex);
        }
        Grandparent defaults = (Grandparent)Assertions.assertDoesNotThrow(configuration::loadDefaults);
        Assertions.assertInstanceOf(type, (Object)defaults);
        Assertions.assertTrue((boolean)defaults.trueDefault());
        Assertions.assertEquals((Object)"usable", (Object)defaults.usableWhenOveridden());
        Assertions.assertEquals(Set.of("hi", "there"), defaults.setWhenOveridden());
        Assertions.assertEquals((int)1, (int)defaults.reabstractMe());
        Assertions.assertDoesNotThrow(() -> defaults.addAnnotation("data"));
        Assertions.assertEquals((Object)"yes added", (Object)defaults.addAnnotation2());
        Assertions.assertEquals((char)'y', (char)defaults.removeAnnotation());
        if (defaults instanceof Auntie) {
            Assertions.assertEquals((Object)"potential gotcha", (Object)((Auntie)defaults).unrelated());
        }
        DataTree.Mut dataTree = new DataTree.Mut();
        dataTree.put("usable", new DataEntry("msg"));
        dataTree.put("setWhenOveridden", new DataEntry(new DataList.Immut(new DataEntry("hi"), new DataEntry("hi"), new DataEntry("hi"))));
        Grandparent readFrom = (Grandparent)configuration.readFrom(dataTree.intoImmut()).getOrThrow();
        Assertions.assertEquals((Object)"usable", (Object)readFrom.usableWhenOveridden());
        Assertions.assertEquals(Set.of("hi"), readFrom.setWhenOveridden());
        Assertions.assertEquals((int)2, (int)readFrom.reabstractMe());
        final UpdateListener updateListener = (UpdateListener)Mockito.mock(UpdateListener.class);
        Grandparent readWithUpdate = (Grandparent)configuration.readWithUpdate(dataTree, new ConfigurationDefinition.ReadWithUpdateOptions(){

            @Override
            public void notifyUpdate(@NonNull KeyPath entryPath, @NonNull UpdateReason updateReason) {
                updateListener.notifyUpdate(entryPath, updateReason);
            }

            @Override
            public @NonNull KeyMapper keyMapper() {
                return new DefaultKeyMapper();
            }

            @Override
            public @NonNull KeyPath keyPath() {
                return new KeyPath.Immut();
            }

            @Override
            public boolean writeEntryComments(@NonNull CommentLocation location) {
                return true;
            }
        }).getOrThrow();
        Assertions.assertEquals((Object)"usable", (Object)readWithUpdate.usableWhenOveridden());
        Assertions.assertEquals(Set.of("hi"), readWithUpdate.setWhenOveridden());
        Assertions.assertEquals((Object)new DataEntry(new DataList.Immut(new DataEntry("hi"))), (Object)dataTree.get("setWhenOveridden"));
        Assertions.assertEquals((Object)new DataEntry(2), (Object)dataTree.get("reabstractMe"));
        ((UpdateListener)Mockito.verify((Object)updateListener)).notifyUpdate(new KeyPath.Mut("setWhenOveridden"), UpdateReason.OTHER);
    }

    public static interface Grandparent {
        public boolean trueDefault();

        public Object usableWhenOveridden();

        default public Collection<String> setWhenOveridden() {
            return List.of("hi", "there");
        }

        default public int reabstractMe() {
            return -1;
        }

        default public void addAnnotation(String ignored) {
        }

        default public String addAnnotation2() {
            return "not added";
        }

        @CallableFn
        default public char removeAnnotation() {
            return 'n';
        }
    }

    public static interface Auntie
    extends Grandparent {
        default public String unrelated() {
            return "potential gotcha";
        }
    }

    public static class ClassProvider
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ParameterDeclarations parameters, ExtensionContext context) {
            return Stream.of(InheritParent.class, InheritParentThenGrandparent.class, InheritGrandparentThenParent.class, InheritParentThenAuntie.class, InheritAuntieThenParent.class, InheritChildThenAuntie.class, InheritAuntieThenChild.class).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
        }
    }

    public static interface InheritAuntieThenChild
    extends Auntie,
    Child {
    }

    public static interface InheritChildThenAuntie
    extends Child,
    Auntie {
    }

    public static interface InheritAuntieThenParent
    extends Auntie,
    Parent {
    }

    public static interface InheritParentThenAuntie
    extends Parent,
    Auntie {
    }

    public static interface InheritGrandparentThenParent
    extends Grandparent,
    Parent {
    }

    public static interface InheritParentThenGrandparent
    extends Parent,
    Grandparent {
    }

    public static interface InheritParent
    extends Parent {
    }

    public static interface Child
    extends Parent {
    }

    public static interface Parent
    extends Grandparent {
        @Override
        default public boolean trueDefault() {
            return true;
        }

        @Override
        default public String usableWhenOveridden() {
            return "usable";
        }

        default public Set<String> setWhenOveridden() {
            return Set.copyOf(Grandparent.super.setWhenOveridden());
        }

        @Override
        @IntegerDefault(value=1, ifMissing=2)
        public int reabstractMe();

        @Override
        @CallableFn
        default public void addAnnotation(String ignored) {
        }

        @Override
        @CallableFn
        default public String addAnnotation2() {
            return "yes added";
        }

        @Override
        default public char removeAnnotation() {
            return 'y';
        }
    }
}

