/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;

public abstract class ImmutabilityGuard<V, S>
implements AutoCloseable {
    private final V value;
    private final S initialSnapshot;
    private final List<ImmutabilityGuard<V, S>> addedValues = new ArrayList<ImmutabilityGuard<V, S>>();

    protected ImmutabilityGuard(V value, V[] extra) {
        this.value = value;
        this.initialSnapshot = this.takeSnapshot(value);
        if (extra.length != 0) {
            Object[] dummyArray = (Object[])Array.newInstance(extra.getClass().getComponentType(), 0);
            for (V append : extra) {
                this.addedValues.add(new AddValue(append, dummyArray));
            }
        }
    }

    protected abstract S takeSnapshot(V var1);

    protected <E> void testImmutable(List<E> list, E dummyElem) {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            list.add(null);
            list.add(dummyElem);
            list.add(0, null);
            list.add(0, dummyElem);
            list.remove(0);
            list.remove(dummyElem);
            list.set(0, dummyElem);
            list.clear();
        });
        Assertions.assertDoesNotThrow(list::size);
        Assertions.assertDoesNotThrow(() -> list.stream().toList());
    }

    private void checkUnchanged() {
        S latestSnapshot = this.takeSnapshot(this.value);
        Assertions.assertEquals(this.initialSnapshot, latestSnapshot);
    }

    public void check() {
        this.checkUnchanged();
        this.addedValues.forEach(ImmutabilityGuard::checkUnchanged);
    }

    @Override
    public void close() {
        this.check();
    }

    class AddValue
    extends ImmutabilityGuard<V, S> {
        protected AddValue(V value, V[] empty) {
            super(value, empty);
        }

        @Override
        protected S takeSnapshot(V value) {
            return ImmutabilityGuard.this.takeSnapshot(value);
        }
    }
}

