/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Configuration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigurationDefinition;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.StandardErrorPrint;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataList;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KebabCaseKeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyPath;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.UpdateReason;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.SubSection;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.DefaultReflectionService;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.Instantiator;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodId;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodMirror;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.ReflectionService;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.ReifiedType;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class ErrorPrintingTest {
    private void expectOutput(final int maximumErrorCollect, DataTree dataTree, String expected) {
        ArrayList printables = new ArrayList();
        StandardErrorPrint errorPrint = new StandardErrorPrint(printables::add);
        LoadResult loadResult = Configuration.defaultBuilder(Config.class).locale(Locale.ENGLISH).reflectionService(new SortedReflectionService(new DefaultReflectionService())).build().readFrom(dataTree, new ConfigurationDefinition.ReadOptions(){

            @Override
            public void notifyUpdate(@NonNull KeyPath entryPath, @NonNull UpdateReason updateReason) {
            }

            @Override
            public @NonNull KeyMapper keyMapper() {
                return new KebabCaseKeyMapper();
            }

            @Override
            public @NonNull KeyPath keyPath() {
                return new KeyPath.Immut();
            }

            @Override
            public int maximumErrorCollect() {
                return maximumErrorCollect;
            }
        });
        Assumptions.assumeFalse((boolean)loadResult.isSuccess());
        errorPrint.onError(loadResult.getErrorContexts());
        StringBuilder builder = new StringBuilder();
        printables.forEach(printable -> printable.printTo(builder));
        String actual = builder.toString().trim();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    private void expectOutput(DataTree dataTree, String expected) {
        this.expectOutput(20, dataTree, expected);
    }

    @Test
    public void singleBadValue() {
        DataTree.Mut dataTree = new DataTree.Mut();
        dataTree.put("opening", new DataEntry("hi"));
        dataTree.put("hello", new DataEntry("goodbye"));
        dataTree.put("enabled", new DataEntry(true));
        dataTree.put("sub-section", new DataEntry(-1));
        this.expectOutput(dataTree, "We found problems loading the configuration file.\nWhere or how the error happened:\n  sub-section: This value is not chosen correctly. The value < -1 > is of type integer, but it should be configuration section.");
    }

    @Test
    public void twoBadValuesAndLineNumber() {
        DataTree.Mut dataTree = new DataTree.Mut();
        dataTree.put("opening", new DataEntry("hi"));
        dataTree.put("hello", new DataEntry("goodbye"));
        dataTree.put("enabled", new DataEntry("BROKEN").withLineNumber(2));
        dataTree.put("sub-section", new DataEntry(-1));
        this.expectOutput(dataTree, "We found problems loading the configuration file.\nWhere or how the error happened:\n  enabled @ line 2: This value is not chosen correctly. The value < BROKEN > is of type text/string, but it should be true/false value.\n  sub-section: This value is not chosen correctly. The value < -1 > is of type integer, but it should be configuration section.");
    }

    @Test
    public void oneBadValueBecauseCapped() {
        DataTree.Mut dataTree = new DataTree.Mut();
        dataTree.put("opening", new DataEntry("hi"));
        dataTree.put("hello", new DataEntry("goodbye"));
        dataTree.put("enabled", new DataEntry("BROKEN").withLineNumber(2));
        dataTree.put("sub-section", new DataEntry(-1));
        this.expectOutput(1, dataTree, "We found problems loading the configuration file.\nWhere or how the error happened:\n  enabled @ line 2: This value is not chosen correctly. The value < BROKEN > is of type text/string, but it should be true/false value.");
    }

    @Test
    public void sixMissingValues() {
        DataTree.Mut dataTree = new DataTree.Mut();
        dataTree.put("opening", new DataEntry("hi"));
        dataTree.put("sub-section", new DataEntry(new DataTree.Immut()));
        this.expectOutput(dataTree, "We found problems loading the configuration file.\nWhere or how the error happened:\n  enabled: No value is configured here but it is required.\n  hello: No value is configured here but it is required.\n  sub-section.character: No value is configured here but it is required.\n  sub-section.decimal-list: No value is configured here but it is required.\n  (+2 more...)");
    }

    @Test
    public void fiveMissingValuesBecauseCapped() {
        DataTree.Mut dataTree = new DataTree.Mut();
        dataTree.put("opening", new DataEntry("hi"));
        dataTree.put("sub-section", new DataEntry(new DataTree.Immut()));
        this.expectOutput(5, dataTree, "We found problems loading the configuration file.\nWhere or how the error happened:\n  enabled: No value is configured here but it is required.\n  hello: No value is configured here but it is required.\n  sub-section.character: No value is configured here but it is required.\n  sub-section.decimal-list: No value is configured here but it is required.\n  (+1 more...)");
    }

    @Test
    public void threeMissingValuesBecauseCapped() {
        this.expectOutput(3, new DataTree.Immut(), "We found problems loading the configuration file.\nWhere or how the error happened:\n  enabled: No value is configured here but it is required.\n  hello: No value is configured here but it is required.\n  opening: No value is configured here but it is required.");
    }

    @Test
    public void errorsInChildElements() {
        DataTree.Mut subSection = new DataTree.Mut();
        subSection.put("integral", new DataEntry(2));
        subSection.put("character", new DataEntry("not a character"));
        subSection.put("decimal-list", new DataEntry(new DataList.Immut(new DataEntry(0.0), new DataEntry(1.1), new DataEntry(-4.9))));
        subSection.put("super-nested-bools", new DataEntry(new DataList.Immut(new DataEntry(new DataList.Immut()), new DataEntry(new DataList.Immut(new DataEntry("true"), new DataEntry("false"), new DataEntry("NA"), new DataEntry("NOPE"))))));
        DataTree.Mut dataTree = new DataTree.Mut();
        dataTree.put("opening", new DataEntry("hi"));
        dataTree.put("hello", new DataEntry("goodbye"));
        dataTree.put("enabled", new DataEntry(false));
        dataTree.put("sub-section", new DataEntry(subSection));
        this.expectOutput(dataTree, "We found problems loading the configuration file.\nWhere or how the error happened:\n  sub-section.character: This value is not chosen correctly. The value < not a character > is of type text/string, but it should be character.\n  sub-section.super-nested-bools.1.2: This value is not chosen correctly. The value < NA > is of type text/string, but it should be true/false value.\n  sub-section.super-nested-bools.1.3: This value is not chosen correctly. The value < NOPE > is of type text/string, but it should be true/false value.");
    }

    @Test
    public void errorsInChildElementsCapped() {
        DataTree.Mut subSection = new DataTree.Mut();
        subSection.put("integral", new DataEntry(2));
        subSection.put("character", new DataEntry("not a character"));
        subSection.put("decimal-list", new DataEntry(new DataList.Immut(new DataEntry(0.0), new DataEntry(1.1), new DataEntry(-4.9))));
        subSection.put("super-nested-bools", new DataEntry(new DataList.Immut(new DataEntry(new DataList.Immut()), new DataEntry(new DataList.Immut(new DataEntry("true"), new DataEntry("false"), new DataEntry("NA"), new DataEntry("NOPE"))))));
        DataTree.Mut dataTree = new DataTree.Mut();
        dataTree.put("opening", new DataEntry("hi"));
        dataTree.put("hello", new DataEntry("goodbye"));
        dataTree.put("enabled", new DataEntry(false));
        dataTree.put("sub-section", new DataEntry(subSection));
        this.expectOutput(2, dataTree, "We found problems loading the configuration file.\nWhere or how the error happened:\n  sub-section.character: This value is not chosen correctly. The value < not a character > is of type text/string, but it should be character.\n  sub-section.super-nested-bools.1.2: This value is not chosen correctly. The value < NA > is of type text/string, but it should be true/false value.");
    }

    public static interface Config {
        public String opening();

        public String hello();

        public boolean enabled();

        public @SubSection SubConfig subSection();

        public static interface SubConfig {
            public int integral();

            public Character character();

            public List<Double> decimalList();

            public Set<Set<Boolean>> superNestedBools();
        }
    }

    record SortedReflectionService(ReflectionService defaultService) implements ReflectionService
    {
        @Override
        public @NonNull Instantiator makeInstantiator( @NonNull MethodHandles.Lookup lookup) {
            return this.defaultService.makeInstantiator(lookup);
        }

        @Override
        public @NonNull MethodMirror makeMethodMirror( @NonNull MethodHandles.Lookup lookup) {
            return new SortedMethodMirror(this.defaultService.makeMethodMirror(lookup));
        }
    }

    record SortedTypeWalker(MethodMirror.TypeWalker delegate) implements MethodMirror.TypeWalker
    {
        @Override
        public @NonNull ReifiedType.Annotated getEnclosingType() {
            return this.delegate.getEnclosingType();
        }

        @Override
        public @NonNull Stream<@NonNull MethodId> getViableMethods() {
            return this.delegate.getViableMethods().sorted(Comparator.comparing(MethodId::name));
        }

        @Override
        public @NonNull AnnotatedElement getAnnotations(@NonNull MethodId methodId) {
            return this.delegate.getAnnotations(methodId);
        }

        @Override
        public @NonNull MethodMirror.TypeWalker @NonNull [] getSuperTypes() {
            MethodMirror.TypeWalker[] superTypes = this.delegate.getSuperTypes();
            for (int n = 0; n < superTypes.length; ++n) {
                superTypes[n] = new SortedTypeWalker(superTypes[n]);
            }
            return superTypes;
        }
    }

    record SortedMethodMirror(MethodMirror methodMirror) implements MethodMirror
    {
        @Override
        public @NonNull MethodMirror.TypeWalker typeWalker(@NonNull ReifiedType.Annotated reifiedType) {
            return new SortedTypeWalker(this.methodMirror.typeWalker(reifiedType));
        }

        @Override
        public @NonNull MethodMirror.Invoker makeInvoker(@NonNull Object receiver, @NonNull Class<?> enclosingType) {
            return this.methodMirror.makeInvoker(receiver, enclosingType);
        }
    }
}

