/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Configuration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigureListener;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ErrorContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ErrorPrint;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Backend;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DefaultKeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.CommentLocation;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class ErrorHandlingTest {
    private final Backend backend;
    private final ErrorPrint errorPrint;

    public ErrorHandlingTest(@Mock Backend backend, @Mock ErrorPrint errorPrint) {
        this.backend = backend;
        this.errorPrint = errorPrint;
    }

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.backend.recommendKeyMapper()).thenReturn((Object)new DefaultKeyMapper());
        Mockito.lenient().when((Object)this.backend.meta()).thenReturn((Object)new Backend.Meta(this){

            @Override
            public boolean supportsComments(boolean documentLevel, boolean reading, @NonNull CommentLocation location) {
                return true;
            }

            @Override
            public boolean preservesOrder(boolean reading) {
                return true;
            }

            @Override
            public boolean writesFloatAsDouble() {
                return false;
            }

            @Override
            public boolean allKeysAreStrings() {
                return false;
            }
        });
    }

    @Test
    public void noErrors() {
        Configuration<Config> configuration = Configuration.defaultBuilder(Config.class).build();
        DataTree.Mut dataTree = new DataTree.Mut();
        dataTree.put("integral", new DataEntry(1));
        Mockito.when(this.backend.read((ErrorContext.Source)Mockito.any())).thenReturn(LoadResult.of(Backend.Document.simple(dataTree)));
        Config loaded = configuration.configureOrFallback(this.backend, this.errorPrint);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.errorPrint});
        Assertions.assertEquals((int)1, (int)loaded.integral());
    }

    @Test
    public void noErrors(@Mock ConfigureListener configureListener) {
        Configuration<Config> configuration = Configuration.defaultBuilder(Config.class).build();
        DataTree.Mut dataTree = new DataTree.Mut();
        dataTree.put("integral", new DataEntry(1));
        Mockito.when(this.backend.read((ErrorContext.Source)Mockito.any())).thenReturn(LoadResult.of(Backend.Document.simple(dataTree)));
        Config loaded = configuration.configureOrFallback(this.backend, configureListener, this.errorPrint);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.errorPrint});
        Mockito.verifyNoInteractions((Object[])new Object[]{configureListener});
        Assertions.assertEquals((int)1, (int)loaded.integral());
    }

    @Test
    public void errorFromBackend(@Mock ErrorContext errorContext) {
        Configuration<Config> config = Configuration.defaultBuilder(Config.class).build();
        Mockito.when(this.backend.read((ErrorContext.Source)Mockito.any())).thenReturn(LoadResult.failure(errorContext));
        Assertions.assertEquals((int)-1, (int)config.configureOrFallback(this.backend, this.errorPrint).integral());
        ((ErrorPrint)Mockito.verify((Object)this.errorPrint)).onError(List.of(errorContext));
    }

    @Test
    public void badValue() {
        Configuration<Config> configuration = Configuration.defaultBuilder(Config.class).build();
        DataTree.Mut dataTree = new DataTree.Mut();
        dataTree.put("integral", new DataEntry("not an integer"));
        Mockito.when(this.backend.read((ErrorContext.Source)Mockito.any())).thenReturn(LoadResult.of(Backend.Document.simple(dataTree)));
        Config loaded = configuration.configureOrFallback(this.backend, this.errorPrint);
        ((ErrorPrint)Mockito.verify((Object)this.errorPrint)).onError((List)Mockito.argThat(list -> !list.isEmpty()));
        Assertions.assertEquals((int)-1, (int)loaded.integral(), (String)"fallback to default value");
    }

    @Test
    public void badValue(@Mock ConfigureListener configureListener) {
        Configuration<Config> configuration = Configuration.defaultBuilder(Config.class).build();
        DataTree.Mut dataTree = new DataTree.Mut();
        dataTree.put("integral", new DataEntry("not an integer"));
        Mockito.when(this.backend.read((ErrorContext.Source)Mockito.any())).thenReturn(LoadResult.of(Backend.Document.simple(dataTree)));
        Config loaded = configuration.configureOrFallback(this.backend, configureListener, this.errorPrint);
        ((ErrorPrint)Mockito.verify((Object)this.errorPrint)).onError((List)Mockito.argThat(list -> !list.isEmpty()));
        Mockito.verifyNoInteractions((Object[])new Object[]{configureListener});
        Assertions.assertEquals((int)-1, (int)loaded.integral(), (String)"fallback to default value");
    }

    public static interface Config {
        default public int integral() {
            return -1;
        }
    }
}

