/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyPath;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Printable;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.lang.LibraryLang;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.Set;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ErrorContext {
    public static final Key<KeyPath> ENTRY_PATH = new Key<KeyPath>(LibraryLang::location, (output, value) -> value.printTo(output));
    public static final Key<Integer> LINE_NUMBER = new Key<Integer>(LibraryLang::line, (output, value) -> output.append(value.toString()));
    public static final Key<Printable> BACKEND_MESSAGE = new Key<Printable>(LibraryLang::backendMessage, (output, value) -> value.printTo(output));
    @API(status=API.Status.EXPERIMENTAL)
    public static final Key<URL> SYNTAX_LINTER = new Key<URL>(LibraryLang::syntaxLinter, (output, value) -> output.append(value.toExternalForm()));

    public @NonNull Locale getLocale();

    public @NonNull Printable mainMessage();

    public @NonNull Printable display();

    public <V> @Nullable V query(@NonNull Key<V> var1);

    public <V> void addDetail(@NonNull Key<V> var1, @NonNull V var2);

    public void clearDetail(@NonNull Key<?> var1);

    public void copyDetailsInto(@NonNull ErrorContext var1);

    public @NonNull Set<@NonNull Key<?>> allKeys();

    public static final class Key<V> {
        final LibraryLang.Key langKey;
        final FormatData<V> formatData;

        Key(LibraryLang.Key langKey, FormatData<V> formatData) {
            this.langKey = langKey;
            this.formatData = formatData;
        }

        static interface FormatData<V> {
            public void format(Appendable var1, V var2) throws IOException;
        }
    }

    public static interface Source {
        public @NonNull Locale getLocale();

        public @NonNull ErrorContext buildError(@NonNull Printable var1);

        public <R> @NonNull LoadResult<R> throwError(@NonNull CharSequence var1);

        public <R> @NonNull LoadResult<R> throwError(@NonNull Printable var1);
    }
}

