/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigurationDefinition;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ErrorContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadError;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataList;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyPath;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Printable;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.DeserializeInput;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.UpdateReason;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.lang.LibraryLang;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

abstract class DeserInput
extends LoadError.Factory
implements DeserializeInput {
    private final DataEntry entry;
    private final LibraryLang libraryLang;
    private final ConfigurationDefinition.ReadOptions readOptions;
    private int childIdx;

    DeserInput(DataEntry entry, LibraryLang libraryLang, ConfigurationDefinition.ReadOptions readOptions) {
        Objects.requireNonNull(entry, "entry");
        this.entry = entry;
        this.libraryLang = libraryLang;
        this.readOptions = readOptions;
    }

    abstract KeyPath.Mut getPathContribution();

    @Override
    public @NonNull DataEntry entry() {
        return this.entry;
    }

    @Override
    public @NonNull LibraryLang getLibraryLang() {
        return this.libraryLang;
    }

    @Override
    public @NonNull KeyPath keyPath() {
        KeyPath.Mut path = this.readOptions.keyPath().intoMut();
        path.addPath(KeyPath.SequenceBoundary.BACK, this.getPathContribution());
        return path;
    }

    @Override
    public @NonNull KeyMapper keyMapper() {
        return this.readOptions.keyMapper();
    }

    private <V> @NonNull LoadResult<@NonNull V> requireAs(Class<V> typeClass) {
        Object object = this.object();
        if (typeClass.isInstance(object)) {
            return LoadResult.of(typeClass.cast(object));
        }
        return this.throwError(this.libraryLang.wrongTypeForValue(object, typeClass));
    }

    @Override
    public @NonNull LoadResult<@NonNull String> requireString() {
        return this.requireAs(String.class);
    }

    @Override
    public @NonNull LoadResult<@NonNull DataTree> requireDataTree() {
        return this.requireAs(DataTree.class);
    }

    @Override
    public @NonNull LoadResult<@NonNull DataList> requireDataList() {
        return this.requireAs(DataList.class);
    }

    @Override
    public void notifyUpdate(@NonNull KeyPath keyPath, @NonNull UpdateReason updateReason) {
        KeyPath.Mut keyPathMut = keyPath.intoMut();
        keyPathMut.addPath(KeyPath.SequenceBoundary.FRONT, this.getPathContribution());
        this.readOptions.notifyUpdate(keyPathMut, updateReason);
    }

    @Override
    public @NonNull DeserializeInput makeChild(@NonNull Object value) {
        return this.makeChild(new DataEntry(value), this.childIdx++);
    }

    @Override
    public @NonNull DeserializeInput makeChild(@NonNull DataEntry entry, @NonNull Object locIdentifier) {
        Objects.requireNonNull(locIdentifier, "locIdentifier");
        return new Child(entry, this.libraryLang, this.readOptions, this, locIdentifier);
    }

    @Override
    public @NonNull ErrorContext buildError(@NonNull Printable message) {
        LoadError loadError = new LoadError(message, this.libraryLang);
        loadError.addDetail(ErrorContext.ENTRY_PATH, this.keyPath());
        Integer lineNumber = this.entry.getLineNumber();
        if (lineNumber != null) {
            loadError.addDetail(ErrorContext.LINE_NUMBER, lineNumber);
        }
        return loadError;
    }

    private static final class Child
    extends DeserInput {
        private final DeserInput parent;
        private final Object locIdentifier;

        Child(DataEntry entry, LibraryLang libraryLang, ConfigurationDefinition.ReadOptions readOptions, DeserInput parent, Object locIdentifier) {
            super(entry, libraryLang, readOptions);
            this.parent = parent;
            this.locIdentifier = locIdentifier;
        }

        @Override
        KeyPath.Mut getPathContribution() {
            KeyPath.Mut contribution = this.parent.getPathContribution();
            contribution.addBack(this.locIdentifier.toString());
            return contribution;
        }
    }

    static class Base
    extends DeserInput {
        private final String mappedKey;

        Base(DataEntry entry, LibraryLang libraryLang, ConfigurationDefinition.ReadOptions readOptions, String mappedKey) {
            super(entry, libraryLang, readOptions);
            this.mappedKey = mappedKey;
        }

        @Override
        KeyPath.Mut getPathContribution() {
            return new KeyPath.Mut(this.mappedKey);
        }
    }
}

