/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigurationDefinition;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Definition;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.DeveloperMistakeException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LiaisonCache;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.TypeSkeleton;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.CommentData;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.CallableFn;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.Comments;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeDeserialize;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.TypeLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.lang.LibraryLang;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.Instantiator;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodId;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodMirror;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.ReifiedType;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.TypeToken;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.dataflow.qual.SideEffectFree;

final class DefinitionScan {
    private final LibraryLang libraryLang;
    private final LiaisonCache liaisonCache;
    private final Instantiator instantiator;
    private final MethodMirror methodMirror;
    private final BlockInfiniteLoop blockReadDefLoop = new BlockInfiniteLoop();

    DefinitionScan(LibraryLang libraryLang, LiaisonCache liaisonCache, Instantiator instantiator, MethodMirror methodMirror) {
        this.libraryLang = libraryLang;
        this.liaisonCache = liaisonCache;
        this.instantiator = instantiator;
        this.methodMirror = methodMirror;
    }

    private static final class BlockInfiniteLoop {
        private final Set<TypeToken<?>> seenBefore = new HashSet();

        private BlockInfiniteLoop() {
        }

        void enter(TypeToken<?> value) {
            if (!this.seenBefore.add(value)) {
                throw new DeveloperMistakeException("Cycle detected. This type was requested before: " + value);
            }
        }

        void exit(TypeToken<?> exitToken) {
            if (!this.seenBefore.remove(exitToken)) {
                throw new IllegalStateException("Gateway value was never added");
            }
        }
    }

    private static final class MethodLocator {
        private final MethodId methodId;

        private MethodLocator(MethodId methodId) {
            this.methodId = methodId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MethodLocator)) {
                return false;
            }
            MethodId us = this.methodId;
            MethodId them = ((MethodLocator)o).methodId;
            if (!us.name().equals(them.name())) {
                return false;
            }
            if (us.parameterCount() != them.parameterCount()) {
                return false;
            }
            for (int n = 0; n < us.parameterCount(); ++n) {
                if (us.parameterAt(n).equals(them.parameterAt(n))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = this.methodId.name().hashCode();
            result = 31 * result + Arrays.hashCode(this.methodId.parameters());
            return result;
        }
    }

    final class Run<V> {
        private final TypeToken<V> typeToken;
        private final LinkedHashMap<Class<?>, ClassContent> classContentMap = new LinkedHashMap();
        private final Map<MethodLocator, Class<?>> methodsFoundWhere = new HashMap();

        Run(TypeToken<V> typeToken) {
            this.typeToken = typeToken;
        }

        private MethodMirror.TypeWalker[] scanHierarchy(MethodMirror.TypeWalker currentWalker) {
            Class<?> currentType = currentWalker.getEnclosingType().rawType();
            if (this.classContentMap.containsKey(currentType)) {
                return new MethodMirror.TypeWalker[0];
            }
            ClassContent classContent = new ClassContent();
            this.classContentMap.put(currentType, classContent);
            currentWalker.getViableMethods().forEachOrdered(methodId -> {
                MethodLocator methodLocator = new MethodLocator((MethodId)methodId);
                Class<?> existingOwner = this.methodsFoundWhere.get(methodLocator);
                if (existingOwner != null) {
                    if (existingOwner.isAssignableFrom(currentType)) {
                        this.classContentMap.get(existingOwner).ownedMethods.remove(methodLocator);
                    } else {
                        assert (currentType.isAssignableFrom(existingOwner));
                        return;
                    }
                }
                classContent.ownedMethods.put(methodLocator, currentWalker.getAnnotations((MethodId)methodId));
                this.methodsFoundWhere.put(methodLocator, currentType);
            });
            return currentWalker.getSuperTypes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ConfigurationDefinition<V> read() {
            Class<V> rawType = this.typeToken.getRawType();
            if (!rawType.isInterface()) {
                throw new DeveloperMistakeException("This library works exclusively with interfaces. " + rawType + " is not an interface.");
            }
            List<MethodMirror.TypeWalker> currentWalkers = Collections.singletonList(DefinitionScan.this.methodMirror.typeWalker(this.typeToken.getReifiedType()));
            while (!currentWalkers.isEmpty()) {
                ArrayList<MethodMirror.TypeWalker> nextWalkers = new ArrayList<MethodMirror.TypeWalker>();
                for (MethodMirror.TypeWalker currentWalker : currentWalkers) {
                    nextWalkers.addAll(Arrays.asList(this.scanHierarchy(currentWalker)));
                }
                currentWalkers = nextWalkers;
            }
            LinkedHashMap typeSkeletons = new LinkedHashMap();
            DefinitionScan.this.blockReadDefLoop.enter(this.typeToken);
            try {
                V defaultsProvider = DefinitionScan.this.instantiator.generateEmpty(rawType);
                for (Map.Entry<Class<?>, ClassContent> classContentEntry : this.classContentMap.entrySet()) {
                    Class<?> enclosingClass = classContentEntry.getKey();
                    ClassContent classContent = classContentEntry.getValue();
                    typeSkeletons.put(enclosingClass, classContent.makeTypeSkeleton(DefinitionScan.this.methodMirror.makeInvoker(defaultsProvider, enclosingClass)));
                }
            }
            finally {
                DefinitionScan.this.blockReadDefLoop.exit(this.typeToken);
            }
            CommentData topLevelComments = CommentData.buildFrom((Comments[])rawType.getAnnotationsByType(Comments.class));
            return new Definition<V>(this.typeToken, topLevelComments, typeSkeletons, DefinitionScan.this.libraryLang, DefinitionScan.this.instantiator, DefinitionScan.this.methodMirror);
        }

        private final class ClassContent {
            private final LinkedHashMap<MethodLocator, AnnotatedElement> ownedMethods = new LinkedHashMap();

            private ClassContent() {
            }

            TypeSkeleton makeTypeSkeleton(MethodMirror.Invoker defaultsInvoker) {
                HashSet<MethodId> callableDefaultMethods = new HashSet<MethodId>();
                ArrayList methodNodes = new ArrayList(this.ownedMethods.size());
                for (Map.Entry<MethodLocator, AnnotatedElement> ownedMethodEntry : this.ownedMethods.entrySet()) {
                    LiaisonCache.HandleType handleType;
                    MethodId methodId = ownedMethodEntry.getKey().methodId;
                    AnnotatedElement methodAnnotations = ownedMethodEntry.getValue();
                    if (methodAnnotations.getAnnotation(CallableFn.class) != null) {
                        if (!methodId.isDefault()) {
                            throw new DeveloperMistakeException("Configuration method " + methodId + " is marked with @CallableFn, but it is not a default method.");
                        }
                        callableDefaultMethods.add(methodId);
                        continue;
                    }
                    if (methodId.parameterCount() != 0) {
                        throw new DeveloperMistakeException("Configuration method " + methodId + " cannot have parameters");
                    }
                    boolean optional = methodId.returnType().rawType().equals(Optional.class);
                    ReifiedType.Annotated typeRequested = optional ? methodId.returnType().argumentAt(0) : methodId.returnType();
                    try {
                        handleType = DefinitionScan.this.liaisonCache.requestToHandle(new TypeToken(typeRequested), new AsHandshake());
                    }
                    catch (DeveloperMistakeException rethrow) {
                        throw new DeveloperMistakeException("Failed to make type agent for " + methodId, rethrow);
                    }
                    methodNodes.add(handleType.makeMethodNode(methodId, optional, methodAnnotations, Run.this.typeToken, defaultsInvoker));
                }
                return new TypeSkeleton(callableDefaultMethods, methodNodes);
            }
        }

        private final class AsHandshake
        implements TypeLiaison.Handshake {
            private final BlockInfiniteLoop blockRequestLoop = new BlockInfiniteLoop();

            private AsHandshake() {
            }

            @Override
            @SideEffectFree
            public <U> @NonNull SerializeDeserialize<U> getOtherSerializer(@NonNull TypeToken<U> other) {
                this.blockRequestLoop.enter(other);
                try {
                    SerializeDeserialize serializeDeserialize = ((DefinitionScan)DefinitionScan.this).liaisonCache.requestToHandle(other, (TypeLiaison.Handshake)this).serializer;
                    return serializeDeserialize;
                }
                finally {
                    this.blockRequestLoop.exit(other);
                }
            }

            @Override
            @SideEffectFree
            public <U> @NonNull ConfigurationDefinition<U> getConfiguration(@NonNull TypeToken<U> other) {
                return new Run<U>(other).read();
            }
        }
    }
}

