/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigurationDefinition;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.DeserInput;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ErrorContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadError;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ModifyComments;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.SerOutput;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.TypeSkeleton;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.CommentData;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyPath;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Printable;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.DeserializeInput;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeDeserialize;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeOutput;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.UpdateReason;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.lang.LibraryLang;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.Instantiator;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodId;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodMirror;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodYield;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.TypeToken;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class Definition<C>
implements ConfigurationDefinition<C> {
    private final TypeToken<C> configType;
    private final CommentData topLevelComments;
    private final LibraryLang libraryLang;
    private final Instantiator instantiator;
    private final MethodMirror methodMirror;
    private final Class<?>[] superTypesArray;
    private final TypeSkeleton[] skeletonArray;

    Definition(TypeToken<C> configType, CommentData topLevelComments, LinkedHashMap<Class<?>, TypeSkeleton> typeSkeletons, LibraryLang libraryLang, Instantiator instantiator, MethodMirror methodMirror) {
        this.configType = Objects.requireNonNull(configType);
        this.topLevelComments = Objects.requireNonNull(topLevelComments);
        this.libraryLang = Objects.requireNonNull(libraryLang);
        this.instantiator = Objects.requireNonNull(instantiator);
        this.methodMirror = Objects.requireNonNull(methodMirror);
        int numberOfSkeletons = typeSkeletons.size();
        Class[] superTypesArray = new Class[numberOfSkeletons];
        TypeSkeleton[] skeletonArray = new TypeSkeleton[numberOfSkeletons];
        int index = numberOfSkeletons;
        for (Map.Entry<Class<?>, TypeSkeleton> typeEntry : typeSkeletons.entrySet()) {
            superTypesArray[--index] = typeEntry.getKey();
            skeletonArray[index] = typeEntry.getValue();
        }
        this.superTypesArray = superTypesArray;
        this.skeletonArray = skeletonArray;
    }

    @Override
    public @NonNull TypeToken<C> getType() {
        return this.configType;
    }

    @Override
    public @NonNull ConfigurationDefinition.Layout getLayout() {
        return new ConfigurationDefinition.Layout(){

            @Override
            public  @NonNull ReifiedType.Annotated getReifiedType() {
                return Definition.this.configType.getReifiedType();
            }

            @Override
            public @NonNull CommentData getComments() {
                return Definition.this.topLevelComments;
            }

            @Override
            public @NonNull Instantiator getInstantiator() {
                return Definition.this.instantiator;
            }

            @Override
            public @NonNull MethodMirror getMethodMirror() {
                return Definition.this.methodMirror;
            }
        };
    }

    @Override
    public @NonNull C loadDefaults() {
        MethodYield methodYield = new MethodYield();
        for (int n = 0; n < this.superTypesArray.length; ++n) {
            Class<?> currentType = this.superTypesArray[n];
            TypeSkeleton typeSkeleton = this.skeletonArray[n];
            try (MethodYield.ForImplementable methodYieldFor = methodYield.forImplementable(currentType);){
                for (MethodId callableMethod : typeSkeleton.callableDefaultMethods) {
                    methodYieldFor.callDefaultImpl(callableMethod);
                }
                for (TypeSkeleton.MethodNode<?> methodNode : typeSkeleton.methodNodes) {
                    Object defaultValue = methodNode.makeDefaultValue(currentType);
                    methodYieldFor.returnValue(methodNode.methodId, defaultValue);
                }
                continue;
            }
        }
        return this.instantiator.generate(this.configType.getRawType(), methodYield);
    }

    private <DT extends DataTree> @NonNull LoadResult<@NonNull C> readingNexus(@NonNull DT dataTree, @NonNull ConfigurationDefinition.ReadOptions readOptions, @NonNull HowToUpdate<DT> howToUpdate) {
        MethodYield methodYield = new MethodYield();
        ErrorContext[] collectedErrors = null;
        int errorCount = 0;
        for (int n = 0; n < this.superTypesArray.length; ++n) {
            Class<?> currentType = this.superTypesArray[n];
            TypeSkeleton typeSkeleton = this.skeletonArray[n];
            try (MethodYield.ForImplementable methodYieldFor = methodYield.forImplementable(currentType);){
                for (MethodId callableMethod : typeSkeleton.callableDefaultMethods) {
                    methodYieldFor.callDefaultImpl(callableMethod);
                }
                for (TypeSkeleton.MethodNode<?> methodNode : typeSkeleton.methodNodes) {
                    ErrorContext[] errorContexts = this.readingNexusForEntry(methodYieldFor, currentType, methodNode, dataTree, readOptions, howToUpdate);
                    if (errorContexts == null) continue;
                    if (collectedErrors == null) {
                        collectedErrors = new ErrorContext[readOptions.maximumErrorCollect()];
                    }
                    for (ErrorContext errorToAppend : errorContexts) {
                        collectedErrors[errorCount++] = errorToAppend;
                        if (errorCount != collectedErrors.length) continue;
                        LoadResult loadResult = LoadResult.failure(collectedErrors);
                        return loadResult;
                    }
                }
                continue;
            }
        }
        if (collectedErrors != null) {
            return LoadResult.failure((ErrorContext[])Arrays.copyOf(collectedErrors, errorCount));
        }
        return LoadResult.of(this.instantiator.generate(this.configType.getRawType(), methodYield));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private <DT extends DataTree, V> @NonNull ErrorContext @Nullable [] readingNexusForEntry(@NonNull MethodYield.ForImplementable methodYieldFor, @NonNull Class<?> currentType, @NonNull TypeSkeleton.MethodNode<V> methodNode, @NonNull DT dataTree, @NonNull ConfigurationDefinition.ReadOptions readOptions, @NonNull HowToUpdate<DT> howToUpdate) {
        void var7_13;
        String mappedKey = readOptions.keyMapper().labelToKey(methodNode.methodId.name()).toString();
        DataEntry dataEntry = dataTree.get(mappedKey);
        if (dataEntry == null) {
            if (methodNode.optional) {
                Optional optional = Optional.empty();
            } else {
                V missingValue;
                V v = missingValue = methodNode.makeMissingValue(currentType);
                if (missingValue == null) {
                    LoadError loadError = new LoadError(Printable.preBuilt(this.libraryLang.missingValue()), this.libraryLang);
                    KeyPath.Mut entryPath = new KeyPath.Mut(readOptions.keyPath());
                    entryPath.addBack(mappedKey);
                    loadError.addDetail(ErrorContext.ENTRY_PATH, entryPath);
                    return new ErrorContext[]{loadError};
                }
                readOptions.notifyUpdate(new KeyPath.Mut(mappedKey), UpdateReason.MISSING);
                howToUpdate.insertMissingValue(dataTree, mappedKey, methodNode, missingValue);
            }
        } else {
            LoadResult valueResult = howToUpdate.deserialize(methodNode.serializer, new DeserInput.Base(dataEntry, this.libraryLang, readOptions, mappedKey));
            if (valueResult.isFailure()) {
                return valueResult.getErrorContexts().toArray(new ErrorContext[0]);
            }
            howToUpdate.updateIfDesired(dataTree, mappedKey, dataEntry, methodNode);
            Object v = valueResult.getOrThrow();
            if (methodNode.optional) {
                Optional optional = Optional.of(v);
            }
        }
        methodYieldFor.returnValue(methodNode.methodId, var7_13);
        return null;
    }

    @Override
    public @NonNull LoadResult<@NonNull C> readFrom(@NonNull DataTree dataTree, @NonNull ConfigurationDefinition.ReadOptions readOptions) {
        return this.readingNexus(dataTree, readOptions, new HowToUpdate<DataTree>(){

            @Override
            public <V> void insertMissingValue(DataTree dataTree, String mappedKey, TypeSkeleton.MethodNode<V> methodNode, V missingValue) {
            }

            @Override
            public <V> LoadResult<V> deserialize(SerializeDeserialize<V> serializeDeserialize, DeserializeInput deser) {
                return serializeDeserialize.deserialize(deser);
            }

            @Override
            public void updateIfDesired(DataTree dataTree, String mappedKey, DataEntry sourceEntry, TypeSkeleton.MethodNode<?> methodNode) {
            }
        });
    }

    @Override
    public @NonNull LoadResult<@NonNull C> readWithUpdate(@NonNull DataTree.Mut dataTree, @NonNull ConfigurationDefinition.ReadWithUpdateOptions readOptions) {
        final ModifyComments modifyComments = new ModifyComments(readOptions);
        final SerOutput outputForUpdate = new SerOutput(readOptions.keyMapper(), modifyComments);
        return this.readingNexus(dataTree, readOptions, new HowToUpdate<DataTree.Mut>(){

            @Override
            public <V> void insertMissingValue(DataTree.Mut dataTree, String mappedKey, TypeSkeleton.MethodNode<V> methodNode, V missingValue) {
                DataEntry serializedMissingValue = methodNode.serialize(missingValue, outputForUpdate);
                dataTree.put(mappedKey, serializedMissingValue.withComments(methodNode.comments));
            }

            @Override
            public <V> LoadResult<V> deserialize(SerializeDeserialize<V> serializeDeserialize, DeserializeInput deser) {
                return serializeDeserialize.deserializeUpdate(deser, outputForUpdate);
            }

            @Override
            public void updateIfDesired(DataTree.Mut dataTree, String mappedKey, DataEntry sourceEntry, TypeSkeleton.MethodNode<?> methodNode) {
                boolean changed = false;
                Object update = outputForUpdate.getAndClearLastOutput();
                if (update != null && !sourceEntry.getValue().equals(update)) {
                    sourceEntry = sourceEntry.withValue(update);
                    changed = true;
                }
                if (modifyComments.isAnyLocationEnabled()) {
                    sourceEntry = modifyComments.applyTo(sourceEntry, methodNode.comments);
                    changed = true;
                }
                if (changed) {
                    dataTree.put(mappedKey, sourceEntry);
                }
            }
        });
    }

    @Override
    public void writeTo(@NonNull C config, @NonNull DataTree.Mut dataTree, @NonNull ConfigurationDefinition.WriteOptions writeOptions) {
        ModifyComments modifyComments = new ModifyComments(writeOptions);
        SerOutput serOutput = new SerOutput(writeOptions.keyMapper(), modifyComments);
        for (int n = 0; n < this.superTypesArray.length; ++n) {
            MethodMirror.Invoker invoker = this.methodMirror.makeInvoker(config, this.superTypesArray[n]);
            for (TypeSkeleton.MethodNode<?> methodNode : this.skeletonArray[n].methodNodes) {
                String mappedKey = writeOptions.keyMapper().labelToKey(methodNode.methodId.name()).toString();
                DataEntry entry = methodNode.serialize(invoker, (SerializeOutput)serOutput);
                if (entry == null) {
                    dataTree.remove(mappedKey);
                    continue;
                }
                if (modifyComments.isAnyLocationEnabled()) {
                    entry = modifyComments.applyTo(entry, methodNode.comments);
                }
                dataTree.put(mappedKey, entry);
            }
        }
    }

    private static interface HowToUpdate<DT extends DataTree> {
        public <V> void insertMissingValue(DT var1, String var2, TypeSkeleton.MethodNode<V> var3, V var4);

        public <V> LoadResult<V> deserialize(SerializeDeserialize<V> var1, DeserializeInput var2);

        public void updateIfDesired(DT var1, String var2, DataEntry var3, TypeSkeleton.MethodNode<?> var4);
    }
}

