/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Configuration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigurationBuilder;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.DeveloperMistakeException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.DefaultValues;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.DeserializeInput;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeDeserialize;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeOutput;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.TypeLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.TypeToken;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CycleDetectionTest {
    @Test
    public void instantCycle() {
        ConfigurationBuilder<SpecialOneOnly> builder = new ConfigurationBuilder<SpecialOneOnly>(new TypeToken<SpecialOneOnly>(this){}).addTypeLiaisons(new SpecialOne.SelfCycle());
        Assertions.assertThrows(DeveloperMistakeException.class, builder::build);
    }

    @Test
    public void instantCycleWhenSerializerIsMade() {
        ConfigurationBuilder<SpecialOneOnly> builder = new ConfigurationBuilder<SpecialOneOnly>(new TypeToken<SpecialOneOnly>(this){}).addTypeLiaisons(new SpecialOne.SelfCycleLater());
        Assertions.assertThrows(DeveloperMistakeException.class, builder::build);
    }

    @Test
    public void cycleBetweenTwins() {
        ConfigurationBuilder<TwinDeviants> builder = new ConfigurationBuilder<TwinDeviants>(new TypeToken<TwinDeviants>(this){}).addTypeLiaisons(new SpecialOne.GoToPrecious(), new ThePrecious.GoToSpecialOne());
        Assertions.assertThrows(DeveloperMistakeException.class, builder::build);
    }

    @Test
    public void cycleBetweenTwinsWhenSerializersAreMade() {
        ConfigurationBuilder<TwinDeviants> builder = new ConfigurationBuilder<TwinDeviants>(new TypeToken<TwinDeviants>(this){}).addTypeLiaisons(new SpecialOne.GoToPreciousLater(), new ThePrecious.GoToSpecialOneLater());
        Assertions.assertThrows(DeveloperMistakeException.class, builder::build);
    }

    @Test
    public void cycleBetweenTwinsOneOfThemWaitsUntilSerializerIsMade() {
        ConfigurationBuilder<TwinDeviants> builder = new ConfigurationBuilder<TwinDeviants>(new TypeToken<TwinDeviants>(this){}).addTypeLiaisons(new SpecialOne.GoToPrecious(), new ThePrecious.GoToSpecialOneLater());
        Assertions.assertThrows(DeveloperMistakeException.class, builder::build);
    }

    @Test
    public void noCycleJustMultipleCalls() {
        ConfigurationBuilder<NoCycleJustMultipleCalls> builder = new ConfigurationBuilder<NoCycleJustMultipleCalls>(new TypeToken<NoCycleJustMultipleCalls>(this){}).addTypeLiaisons(new ThePrecious.FunctionalLiaison());
        Configuration configuration = (Configuration)Assertions.assertDoesNotThrow(builder::build);
        DataTree.Mut dataTree = new DataTree.Mut();
        dataTree.put("precious1", new DataEntry(1));
        dataTree.put("precious2", new DataEntry(2));
        NoCycleJustMultipleCalls loaded = (NoCycleJustMultipleCalls)configuration.readFrom(dataTree).getOrThrow();
        DataTree.Mut output = new DataTree.Mut();
        configuration.writeTo(loaded, output);
        Assertions.assertEquals((Object)new DataEntry(0), (Object)output.get("precious1"));
        Assertions.assertEquals((Object)new DataEntry(0), (Object)output.get("precious2"));
    }

    public record SpecialOne() {

        public record GoToPreciousLater() implements TypeLiaison
        {
            @Override
            public <V> @Nullable TypeLiaison.Agent<V> makeAgent(@NonNull TypeToken<V> typeToken, final @NonNull TypeLiaison.Handshake handshake) {
                return TypeLiaison.Agent.matchOnToken(typeToken, SpecialOne.class, () -> new TypeLiaison.Agent<SpecialOne>(this){

                    @Override
                    public @Nullable DefaultValues<SpecialOne> loadDefaultValues(@NonNull TypeLiaison.DefaultInit defaultInit) {
                        return null;
                    }

                    @Override
                    public @NonNull SerializeDeserialize<SpecialOne> makeSerializer() {
                        handshake.getOtherSerializer(new TypeToken<ThePrecious>(this){});
                        assert (false) : "Should not reach here (test failed)";
                        return null;
                    }
                });
            }
        }

        public record GoToPrecious() implements TypeLiaison
        {
            @Override
            public <V> @Nullable TypeLiaison.Agent<V> makeAgent(@NonNull TypeToken<V> typeToken, @NonNull TypeLiaison.Handshake handshake) {
                return TypeLiaison.Agent.matchOnToken(typeToken, SpecialOne.class, () -> {
                    handshake.getOtherSerializer(new TypeToken<ThePrecious>(this){});
                    assert (false) : "Should not reach here (test failed)";
                    return null;
                });
            }
        }

        public record SelfCycleLater() implements TypeLiaison
        {
            @Override
            public <V> @Nullable TypeLiaison.Agent<V> makeAgent(@NonNull TypeToken<V> typeToken, final @NonNull TypeLiaison.Handshake handshake) {
                return TypeLiaison.Agent.matchOnToken(typeToken, SpecialOne.class, () -> new TypeLiaison.Agent<SpecialOne>(){

                    @Override
                    public @Nullable DefaultValues<SpecialOne> loadDefaultValues(@NonNull TypeLiaison.DefaultInit defaultInit) {
                        return null;
                    }

                    @Override
                    public @NonNull SerializeDeserialize<SpecialOne> makeSerializer() {
                        handshake.getOtherSerializer(new TypeToken<SpecialOne>(this){});
                        assert (false) : "Should not reach here (test failed)";
                        return null;
                    }
                });
            }
        }

        public record SelfCycle() implements TypeLiaison
        {
            @Override
            public <V> @Nullable TypeLiaison.Agent<V> makeAgent(@NonNull TypeToken<V> typeToken, @NonNull TypeLiaison.Handshake handshake) {
                return TypeLiaison.Agent.matchOnToken(typeToken, SpecialOne.class, () -> {
                    handshake.getOtherSerializer(new TypeToken<SpecialOne>(this){});
                    assert (false) : "Should not reach here (test failed)";
                    return null;
                });
            }
        }
    }

    public record ThePrecious() {

        public record FunctionalLiaison() implements TypeLiaison
        {
            @Override
            public <V> @Nullable TypeLiaison.Agent<V> makeAgent(@NonNull TypeToken<V> typeToken, @NonNull TypeLiaison.Handshake handshake) {
                return TypeLiaison.Agent.matchOnToken(typeToken, ThePrecious.class, () -> new TypeLiaison.Agent<ThePrecious>(this){

                    @Override
                    public @Nullable DefaultValues<ThePrecious> loadDefaultValues(@NonNull TypeLiaison.DefaultInit defaultInit) {
                        return null;
                    }

                    @Override
                    public @NonNull SerializeDeserialize<ThePrecious> makeSerializer() {
                        final ThePrecious instance = new ThePrecious();
                        return new SerializeDeserialize<ThePrecious>(this){

                            @Override
                            public @NonNull LoadResult<@NonNull ThePrecious> deserialize(@NonNull DeserializeInput deser) {
                                return LoadResult.of(instance);
                            }

                            @Override
                            public void serialize(@NonNull ThePrecious value, @NonNull SerializeOutput ser) {
                                assert (value == instance);
                                ser.outInt(0);
                            }
                        };
                    }
                });
            }
        }

        public record GoToSpecialOneLater() implements TypeLiaison
        {
            @Override
            public <V> @Nullable TypeLiaison.Agent<V> makeAgent(@NonNull TypeToken<V> typeToken, final @NonNull TypeLiaison.Handshake handshake) {
                return TypeLiaison.Agent.matchOnToken(typeToken, ThePrecious.class, () -> new TypeLiaison.Agent<ThePrecious>(this){

                    @Override
                    public @Nullable DefaultValues<ThePrecious> loadDefaultValues(@NonNull TypeLiaison.DefaultInit defaultInit) {
                        return null;
                    }

                    @Override
                    public @NonNull SerializeDeserialize<ThePrecious> makeSerializer() {
                        handshake.getOtherSerializer(new TypeToken<SpecialOne>(this){});
                        assert (false) : "Should not reach here (test failed)";
                        return null;
                    }
                });
            }
        }

        public record GoToSpecialOne() implements TypeLiaison
        {
            @Override
            public <V> @Nullable TypeLiaison.Agent<V> makeAgent(@NonNull TypeToken<V> typeToken, @NonNull TypeLiaison.Handshake handshake) {
                return TypeLiaison.Agent.matchOnToken(typeToken, ThePrecious.class, () -> {
                    handshake.getOtherSerializer(new TypeToken<SpecialOne>(this){});
                    assert (false) : "Should not reach here (test failed)";
                    return null;
                });
            }
        }
    }

    public static interface NoCycleJustMultipleCalls {
        public ThePrecious precious1();

        public ThePrecious precious2();
    }

    public static interface TwinDeviants {
        public SpecialOne specialOne();

        public ThePrecious thePrecious();
    }

    public static interface SpecialOneOnly {
        public SpecialOne specialOne();
    }
}

