/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Configuration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigureListener;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ErrorContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.MatchDocumentData;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.MigrationTest;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Backend;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DefaultKeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyPath;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.CommentLocation;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.UpdateReason;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatcher;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class ConfigureTest {
    private final Backend backend;

    public ConfigureTest(@Mock Backend backend) {
        this.backend = backend;
    }

    @BeforeEach
    public void setup() {
        Mockito.lenient().when((Object)this.backend.meta()).thenReturn((Object)new Backend.Meta(this){

            @Override
            public boolean supportsComments(boolean documentLevel, boolean reading, @NonNull CommentLocation location) {
                return true;
            }

            @Override
            public boolean preservesOrder(boolean reading) {
                return true;
            }

            @Override
            public boolean writesFloatAsDouble() {
                return false;
            }

            @Override
            public boolean allKeysAreStrings() {
                return false;
            }
        });
    }

    @Test
    public void nullKeyMapper() {
        Configuration<Config> config = Configuration.defaultBuilder(Config.class).build();
        Mockito.when((Object)this.backend.recommendKeyMapper()).thenReturn(null);
        Assertions.assertThrows(NullPointerException.class, () -> config.configureWith(this.backend));
    }

    @Test
    public void erroredOut(@Mock ErrorContext errorContext) {
        Configuration<Config> config = Configuration.defaultBuilder(Config.class).build();
        Mockito.when((Object)this.backend.recommendKeyMapper()).thenReturn((Object)new DefaultKeyMapper());
        Mockito.when(this.backend.read((ErrorContext.Source)Mockito.any())).thenReturn(LoadResult.failure(errorContext));
        LoadResult<Config> configureWith = config.configureWith(this.backend);
        Assertions.assertTrue((boolean)configureWith.isFailure());
        Assertions.assertEquals(List.of(errorContext), configureWith.getErrorContexts());
    }

    @Test
    public void loadDefaults(@Mock ConfigureListener configureListener) {
        Configuration<MigrationTest.Destination> config = Configuration.defaultBuilder(MigrationTest.Destination.class).build();
        Mockito.when((Object)this.backend.recommendKeyMapper()).thenReturn((Object)new DefaultKeyMapper());
        Mockito.when(this.backend.read((ErrorContext.Source)Mockito.any())).thenReturn(LoadResult.of(null));
        MigrationTest.Destination defaultValues = config.configureWith(this.backend, configureListener).getOrThrow();
        Assertions.assertEquals((Object)"goodbye", (Object)defaultValues.hello());
        Assertions.assertEquals((char)'y', (char)defaultValues.affirmative());
        ((ConfigureListener)Mockito.verify((Object)configureListener)).wroteDefaults();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{configureListener});
        DataTree.Mut expectedWriteBack = new DataTree.Mut();
        expectedWriteBack.put("hello", new DataEntry("goodbye"));
        expectedWriteBack.put("affirmative", new DataEntry(Character.valueOf('y')));
        ((Backend)Mockito.verify((Object)this.backend)).write((Backend.Document)Mockito.argThat((ArgumentMatcher)new MatchDocumentData(expectedWriteBack)));
    }

    @Test
    public void loadMissingValue(@Mock ConfigureListener configureListener) {
        Configuration<MigrationTest.Destination> config = Configuration.defaultBuilder(MigrationTest.Destination.class).build();
        Mockito.when((Object)this.backend.recommendKeyMapper()).thenReturn((Object)new DefaultKeyMapper());
        Mockito.when(this.backend.read((ErrorContext.Source)Mockito.any())).thenReturn(LoadResult.of(Backend.Document.simple(new DataTree.Immut())));
        MigrationTest.Destination withMissing = config.configureWith(this.backend, configureListener).getOrThrow();
        Assertions.assertEquals((Object)"goodbye-default-if-missing", (Object)withMissing.hello());
        Assertions.assertEquals((char)'y', (char)withMissing.affirmative());
        ((ConfigureListener)Mockito.verify((Object)configureListener)).notifyUpdate((KeyPath)Mockito.eq((Object)new KeyPath.Mut("hello")), (UpdateReason)((Object)Mockito.eq((Object)((Object)UpdateReason.MISSING))));
        ((ConfigureListener)Mockito.verify((Object)configureListener)).notifyUpdate((KeyPath)Mockito.eq((Object)new KeyPath.Mut("affirmative")), (UpdateReason)((Object)Mockito.eq((Object)((Object)UpdateReason.MISSING))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{configureListener});
        DataTree.Mut expectedWriteBack = new DataTree.Mut();
        expectedWriteBack.put("hello", new DataEntry("goodbye-default-if-missing"));
        expectedWriteBack.put("affirmative", new DataEntry(Character.valueOf('y')));
        ((Backend)Mockito.verify((Object)this.backend)).write((Backend.Document)Mockito.argThat((ArgumentMatcher)new MatchDocumentData(expectedWriteBack)));
    }

    @Test
    public void loadPartialMissingValue(@Mock ConfigureListener configureListener) {
        Configuration<MigrationTest.Destination> config = Configuration.defaultBuilder(MigrationTest.Destination.class).build();
        Mockito.when((Object)this.backend.recommendKeyMapper()).thenReturn((Object)new DefaultKeyMapper());
        DataTree.Mut dataTree = new DataTree.Mut();
        dataTree.put("hello", new DataEntry("present"));
        Mockito.when(this.backend.read((ErrorContext.Source)Mockito.any())).thenReturn(LoadResult.of(Backend.Document.simple(dataTree)));
        MigrationTest.Destination withMissing = config.configureWith(this.backend, configureListener).getOrThrow();
        Assertions.assertEquals((Object)"present", (Object)withMissing.hello());
        Assertions.assertEquals((char)'y', (char)withMissing.affirmative());
        ((ConfigureListener)Mockito.verify((Object)configureListener)).notifyUpdate((KeyPath)Mockito.eq((Object)new KeyPath.Mut("affirmative")), (UpdateReason)((Object)Mockito.eq((Object)((Object)UpdateReason.MISSING))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{configureListener});
        DataTree.Mut expectedWriteBack = new DataTree.Mut();
        expectedWriteBack.put("hello", new DataEntry("present"));
        expectedWriteBack.put("affirmative", new DataEntry(Character.valueOf('y')));
        ((Backend)Mockito.verify((Object)this.backend)).write((Backend.Document)Mockito.argThat((ArgumentMatcher)new MatchDocumentData(expectedWriteBack)));
    }

    public static interface Config {
        default public String hello() {
            return "goodbye";
        }

        default public char affirmative() {
            return 'y';
        }
    }
}

