/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Configuration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataList;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.TypeToken;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfigurationTest {
    @Test
    public void simple() {
        Configuration<HelloWorld> config = Configuration.defaultBuilder(HelloWorld.class).build();
        Assertions.assertEquals((Object)"hi", (Object)((HelloWorld)config.loadDefaults()).helloThere());
        DataTree.Mut sourceTree = new DataTree.Mut();
        sourceTree.put("helloThere", new DataEntry("goodbye"));
        HelloWorld loadedFromSource = config.readFrom(sourceTree.intoImmut()).getOrThrow();
        Assertions.assertEquals((Object)"goodbye", (Object)loadedFromSource.helloThere());
        DataTree.Mut writeBack = new DataTree.Mut();
        config.writeTo(loadedFromSource, writeBack);
        Assertions.assertEquals((Object)sourceTree, (Object)writeBack);
        DataTree.Mut writeCustom = new DataTree.Mut();
        writeCustom.put("helloThere", new DataEntry("bye"));
        DataTree.Mut output = new DataTree.Mut();
        config.writeTo(new HelloWorld(this){

            @Override
            public String helloThere() {
                return "bye";
            }
        }, output);
        Assertions.assertEquals((Object)writeCustom, (Object)output);
    }

    @Test
    public void generic() {
        Configuration<GenericWorld<String>> config = Configuration.defaultBuilder(new TypeToken<GenericWorld<String>>(this){}).build();
        Assertions.assertEquals(List.of(), ((GenericWorld)config.loadDefaults()).testList());
        List<String> testList = List.of("hi", "nope", "yes");
        DataTree.Mut sourceTree = new DataTree.Mut();
        sourceTree.put("testList", new DataEntry(new DataList.Mut(new DataEntry("hi"), new DataEntry("nope"), new DataEntry("yes"))));
        GenericWorld<String> loadedFromSource = config.readFrom(sourceTree).getOrThrow();
        Assertions.assertEquals(testList, loadedFromSource.testList());
        DataTree.Mut writeBack = new DataTree.Mut();
        config.writeTo(loadedFromSource, writeBack);
        Assertions.assertEquals((Object)sourceTree, (Object)writeBack);
        DataTree.Mut writeCustom = new DataTree.Mut();
        writeCustom.put("testList", new DataEntry(new DataList.Immut(new DataEntry("1"), new DataEntry("2"))));
        DataTree.Mut output = new DataTree.Mut();
        config.writeTo(new GenericWorld<String>(this){

            @Override
            public List<String> testList() {
                return List.of("1", "2");
            }
        }, output);
        Assertions.assertEquals((Object)writeCustom, (Object)output);
    }

    @Test
    public void inherited() {
        Configuration<InheritedWorld> config = Configuration.defaultBuilder(InheritedWorld.class).build();
        Assertions.assertEquals((Object)"hi", (Object)((InheritedWorld)config.loadDefaults()).helloThere());
        Assertions.assertEquals(List.of(), ((InheritedWorld)config.loadDefaults()).testList());
        List<Integer> testList = List.of(Integer.valueOf(1), Integer.valueOf(3));
        DataTree.Mut sourceTree = new DataTree.Mut();
        sourceTree.put("helloThere", new DataEntry("goodbye"));
        sourceTree.put("testList", new DataEntry(new DataList.Mut(new DataEntry(1), new DataEntry(3))));
        InheritedWorld loadedFromSource = config.readFrom(sourceTree).getOrThrow();
        Assertions.assertEquals((Object)"goodbye", (Object)loadedFromSource.helloThere());
        Assertions.assertEquals(testList, loadedFromSource.testList());
        DataTree.Mut writeBack = new DataTree.Mut();
        config.writeTo(loadedFromSource, writeBack);
        Assertions.assertEquals((Object)sourceTree, (Object)writeBack);
        DataTree.Mut writeCustom = new DataTree.Mut();
        writeCustom.put("helloThere", new DataEntry("bye"));
        writeCustom.put("testList", new DataEntry(new DataList.Mut(new DataEntry(4), new DataEntry(5))));
        DataTree.Mut output = new DataTree.Mut();
        config.writeTo(new InheritedWorld(this){

            @Override
            public String helloThere() {
                return "bye";
            }

            @Override
            public List<Integer> testList() {
                return List.of(Integer.valueOf(4), Integer.valueOf(5));
            }
        }, output);
        Assertions.assertEquals((Object)writeCustom, (Object)output);
    }

    public static interface HelloWorld {
        default public String helloThere() {
            return "hi";
        }
    }

    public static interface GenericWorld<T> {
        default public List<T> testList() {
            return List.of();
        }
    }

    public static interface InheritedWorld
    extends GenericWorld<Integer>,
    HelloWorld {
    }
}

