/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Configuration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigurationDefinition;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.CommentData;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataList;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KebabCaseKeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyPath;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.CommentLocation;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.Comments;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.UpdateListener;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.UpdateReason;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.SubSection;
import java.lang.reflect.AccessFlag;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class ConfigurationMechanicsTest {
    private Configuration<Config> configuration;
    private final UpdateListener updateListener;
    private final KeyMapper keyMapper = new KebabCaseKeyMapper();

    public ConfigurationMechanicsTest(@Mock UpdateListener updateListener) {
        this.updateListener = updateListener;
    }

    @BeforeEach
    public void setup() {
        this.configuration = Configuration.defaultBuilder(Config.class).build();
    }

    @Test
    public void getTopLevelComments() {
        Assertions.assertEquals((Object)CommentData.empty().setAt(CommentLocation.ABOVE, "Comment header expected"), (Object)this.configuration.getLayout().getComments());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void readKeyMapped(boolean updatableValues) {
        String inherited = "inheritance";
        char keyPress = 'k';
        List<List<List<String>>> matrix = List.of(List.of(List.of("beside"), List.of(), List.of("hello", "crazy")));
        Set<Float> floats = Set.of(Float.valueOf(1.4f));
        StandardCopyOption smallEnum = StandardCopyOption.COPY_ATTRIBUTES;
        boolean enabled = true;
        String message = "msg";
        AccessFlag bigEnum = AccessFlag.MANDATED;
        DataTree.Mut dataTree = new DataTree.Mut();
        dataTree.put("inherited", new DataEntry(inherited));
        dataTree.put("key-press", new DataEntry(updatableValues ? String.valueOf(keyPress) : Character.valueOf(keyPress)));
        dataTree.put("matrix", new DataEntry(new DataList.Immut(new DataEntry(new DataList.Immut(new DataEntry(new DataList.Immut(new DataEntry("beside"))), new DataEntry(new DataList.Immut()), new DataEntry(new DataList.Immut(new DataEntry("hello"), new DataEntry("crazy"))))))));
        dataTree.put("floats", new DataEntry(new DataList.Immut(new DataEntry(floats.iterator().next()))));
        dataTree.put("small-enum", new DataEntry(smallEnum.name()));
        DataTree.Mut subTree = new DataTree.Mut();
        dataTree.put("sub-section", new DataEntry(subTree));
        subTree.put("enabled", new DataEntry(updatableValues ? String.valueOf(enabled) : Boolean.valueOf(enabled)));
        subTree.put("message", new DataEntry(message));
        subTree.put("big-enum", new DataEntry(bigEnum.name()));
        LoadResult loadResult = this.configuration.readFrom((DataTree)dataTree, new ConfigurationDefinition.ReadOptions(){

            @Override
            public void notifyUpdate(@NonNull KeyPath entryPath, @NonNull UpdateReason updateReason) {
                ConfigurationMechanicsTest.this.updateListener.notifyUpdate(entryPath, updateReason);
            }

            @Override
            public @NonNull KeyMapper keyMapper() {
                return ConfigurationMechanicsTest.this.keyMapper;
            }

            @Override
            public @NonNull KeyPath keyPath() {
                return new KeyPath.Immut();
            }
        });
        Assertions.assertTrue((boolean)loadResult.isSuccess());
        if (updatableValues) {
            ((UpdateListener)Mockito.verify((Object)this.updateListener)).notifyUpdate(new KeyPath.Immut("sub-section", "enabled"), UpdateReason.UPDATED);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.updateListener});
        } else {
            Mockito.verifyNoInteractions((Object[])new Object[]{this.updateListener});
        }
        Config loaded = (Config)loadResult.getOrThrow();
        Assertions.assertEquals((Object)inherited, (Object)loaded.inherited());
        Assertions.assertEquals((char)keyPress, (char)loaded.keyPress());
        Assertions.assertEquals(matrix, loaded.matrix());
        Assertions.assertEquals(floats, loaded.floats());
        Assertions.assertEquals((Object)smallEnum, (Object)loaded.smallEnum());
        Config.Section section = loaded.subSection();
        Assertions.assertEquals((Object)enabled, (Object)section.enabled());
        Assertions.assertEquals((Object)message, (Object)section.message());
        Assertions.assertEquals((Object)((Object)bigEnum), (Object)((Object)section.bigEnum()));
    }

    @Test
    public void writeKeyMapped() {
        final String inherited = "inheritance";
        final char keyPress = 'k';
        final List<List<List<String>>> matrix = List.of(List.of(List.of("beside"), List.of(), List.of("hello", "crazy")));
        final Set<Float> floats = Set.of(Float.valueOf(1.4f));
        final StandardCopyOption smallEnum = StandardCopyOption.COPY_ATTRIBUTES;
        final boolean enabled = true;
        final String message = "msg";
        final AccessFlag bigEnum = AccessFlag.MANDATED;
        Config config = new Config(){

            @Override
            public String inherited() {
                return inherited;
            }

            @Override
            public char keyPress() {
                return keyPress;
            }

            @Override
            public List<List<List<String>>> matrix() {
                return matrix;
            }

            @Override
            public Set<Float> floats() {
                return floats;
            }

            @Override
            public StandardCopyOption smallEnum() {
                return smallEnum;
            }

            @Override
            public @SubSection Config.Section subSection() {
                return new Config.Section(){

                    @Override
                    public boolean enabled() {
                        return enabled;
                    }

                    @Override
                    public String message() {
                        return message;
                    }

                    @Override
                    public AccessFlag bigEnum() {
                        return bigEnum;
                    }
                };
            }
        };
        DataTree.Mut dataTree = new DataTree.Mut();
        this.configuration.writeTo(config, dataTree, () -> this.keyMapper);
        Assertions.assertEquals((Object)new DataEntry(inherited), (Object)dataTree.get("inherited"));
        DataEntry keyPressEntry = dataTree.get("key-press");
        Assertions.assertNotNull((Object)keyPressEntry);
        Assertions.assertEquals((Object)Character.valueOf(keyPress), (Object)keyPressEntry.getValue());
        Assertions.assertEquals((Object)CommentData.empty().setAt(CommentLocation.ABOVE, "Game control key"), (Object)keyPressEntry.getComments());
        Assertions.assertEquals((Object)new DataEntry(new DataList.Immut(new DataEntry(new DataList.Immut(new DataEntry(new DataList.Immut(new DataEntry("beside"))), new DataEntry(new DataList.Immut()), new DataEntry(new DataList.Immut(new DataEntry("hello"), new DataEntry("crazy"))))))), (Object)dataTree.get("matrix"));
        Assertions.assertEquals((Object)new DataEntry(new DataList.Immut(new DataEntry(floats.iterator().next()))), (Object)dataTree.get("floats"));
        Assertions.assertEquals((Object)new DataEntry(smallEnum.name()), (Object)dataTree.get("small-enum"));
        DataEntry subEntry = dataTree.get("sub-section");
        Assertions.assertNotNull((Object)subEntry);
        Assertions.assertEquals((Object)CommentData.empty().setAt(CommentLocation.INLINE, "Comments placed on subsection key"), (Object)subEntry.getComments());
        DataTree.Mut subTree = ((DataTree)Assertions.assertInstanceOf(DataTree.class, (Object)subEntry.getValue())).intoMut();
        Assertions.assertEquals((Object)new DataEntry(enabled), (Object)subTree.get("enabled"));
        DataEntry messageEntry = subTree.get("message");
        Assertions.assertNotNull((Object)messageEntry);
        Assertions.assertEquals((Object)message, (Object)messageEntry.getValue());
        Assertions.assertEquals((Object)CommentData.empty().setAt(CommentLocation.ABOVE, "What to send players"), (Object)messageEntry.getComments());
        Assertions.assertEquals((Object)new DataEntry(message), (Object)subTree.get("message"));
        Assertions.assertEquals((Object)new DataEntry(bigEnum.name()), (Object)subTree.get("big-enum"));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void readWithUpdateKeyMapped(boolean updatableValues) {
        String inherited = "inheritance";
        char keyPress = 'k';
        List<List<List<String>>> matrix = List.of(List.of(List.of("beside"), List.of(), List.of("hello", "crazy")));
        Set<Float> floats = Set.of(Float.valueOf(1.4f));
        StandardCopyOption smallEnum = StandardCopyOption.COPY_ATTRIBUTES;
        boolean enabled = true;
        String message = "msg";
        AccessFlag bigEnum = AccessFlag.MANDATED;
        DataTree.Mut dataTree = new DataTree.Mut();
        dataTree.put("inherited", new DataEntry(inherited));
        dataTree.put("key-press", new DataEntry(updatableValues ? String.valueOf(keyPress) : Character.valueOf(keyPress)).withComments(CommentLocation.ABOVE, List.of("Game control key (edited)")));
        dataTree.put("matrix", new DataEntry(new DataList.Immut(new DataEntry(new DataList.Immut(new DataEntry(new DataList.Immut(new DataEntry("beside"))), new DataEntry(new DataList.Immut()), new DataEntry(new DataList.Immut(new DataEntry("hello"), new DataEntry("crazy"))))))));
        dataTree.put("floats", new DataEntry(new DataList.Immut(new DataEntry(floats.iterator().next()))));
        dataTree.put("small-enum", new DataEntry(smallEnum.name()));
        DataTree.Mut subTree = new DataTree.Mut();
        dataTree.put("sub-section", new DataEntry(subTree).withComments(CommentLocation.INLINE, List.of("Comments placed on subsection declaration")));
        subTree.put("enabled", new DataEntry(updatableValues ? String.valueOf(enabled) : Boolean.valueOf(enabled)));
        subTree.put("message", new DataEntry(message));
        subTree.put("big-enum", new DataEntry(bigEnum.name()));
        LoadResult loadResult = this.configuration.readWithUpdate(dataTree, new ConfigurationDefinition.ReadWithUpdateOptions(){

            @Override
            public void notifyUpdate(@NonNull KeyPath entryPath, @NonNull UpdateReason updateReason) {
                ConfigurationMechanicsTest.this.updateListener.notifyUpdate(entryPath, updateReason);
            }

            @Override
            public @NonNull KeyMapper keyMapper() {
                return ConfigurationMechanicsTest.this.keyMapper;
            }

            @Override
            public @NonNull KeyPath keyPath() {
                return new KeyPath.Immut();
            }

            @Override
            public boolean writeEntryComments(@NonNull CommentLocation location) {
                return false;
            }
        });
        Assertions.assertTrue((boolean)loadResult.isSuccess());
        if (updatableValues) {
            ((UpdateListener)Mockito.verify((Object)this.updateListener)).notifyUpdate(new KeyPath.Mut("sub-section", "enabled"), UpdateReason.UPDATED);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.updateListener});
        } else {
            Mockito.verifyNoInteractions((Object[])new Object[]{this.updateListener});
        }
        Assertions.assertEquals((Object)new DataEntry(inherited), (Object)dataTree.get("inherited"));
        Assertions.assertEquals((Object)new DataEntry(Character.valueOf(keyPress)), (Object)dataTree.get("key-press"));
        DataEntry keyPressEntry = dataTree.get("key-press");
        Assertions.assertNotNull((Object)keyPressEntry);
        Assertions.assertEquals((Object)new DataEntry(Character.valueOf(keyPress)), (Object)keyPressEntry);
        Assertions.assertEquals((Object)CommentData.empty().setAt(CommentLocation.ABOVE, "Game control key (edited)"), (Object)keyPressEntry.getComments());
        Assertions.assertEquals((Object)new DataEntry(new DataList.Immut(new DataEntry(new DataList.Immut(new DataEntry(new DataList.Immut(new DataEntry("beside"))), new DataEntry(new DataList.Immut()), new DataEntry(new DataList.Immut(new DataEntry("hello"), new DataEntry("crazy"))))))), (Object)dataTree.get("matrix"));
        Assertions.assertEquals((Object)new DataEntry(new DataList.Immut(new DataEntry(floats.iterator().next()))), (Object)dataTree.get("floats"));
        Assertions.assertEquals((Object)new DataEntry(smallEnum.name()), (Object)dataTree.get("small-enum"));
        DataEntry subEntry = dataTree.get("sub-section");
        Assertions.assertNotNull((Object)subEntry);
        Assertions.assertEquals((Object)CommentData.empty().setAt(CommentLocation.INLINE, "Comments placed on subsection declaration"), (Object)subEntry.getComments());
        subTree = ((DataTree)Assertions.assertInstanceOf(DataTree.class, (Object)subEntry.getValue())).intoMut();
        Assertions.assertEquals((Object)new DataEntry(enabled), (Object)subTree.get("enabled"));
        DataEntry messageEntry = subTree.get("message");
        Assertions.assertNotNull((Object)messageEntry);
        Assertions.assertEquals((Object)message, (Object)messageEntry.getValue());
        Assertions.assertEquals((Object)CommentData.empty(), (Object)messageEntry.getComments());
        Assertions.assertEquals((Object)new DataEntry(bigEnum.name()), (Object)subTree.get("big-enum"));
    }

    @Comments(value={"Comment header expected"})
    public static interface Config
    extends Parent {
        @Comments(value={"Game control key"})
        public char keyPress();

        public List<List<List<String>>> matrix();

        public Set<Float> floats();

        public StandardCopyOption smallEnum();

        @Comments(value={"Comments placed on subsection key"}, location=CommentLocation.INLINE)
        public @SubSection Section subSection();

        @Comments(value={"Comments placed on subsection declaration"}, location=CommentLocation.INLINE)
        public static interface Section {
            public boolean enabled();

            @Comments(value={"What to send players"})
            public String message();

            public AccessFlag bigEnum();
        }
    }

    @Comments(value={"Inherited comment should not be passed down"})
    public static interface Parent {
        public String inherited();
    }
}

