/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.BuiltConfig;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Configuration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigurationDefinition;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.DefinitionScan;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LiaisonCache;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeDeserialize;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.TypeLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.BooleanLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.ByteLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.CharacterLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.CollectionLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.DoubleLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.EnumLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.FloatLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.IntegerLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.LongLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.MapLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.ShortLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.SimpleTypeLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.StringLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.SubSectionLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.ImmutableCollections;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.lang.LibraryLang;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.migration.Migration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.DefaultReflectionService;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.ReflectionService;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.TypeToken;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.returnsreceiver.qual.This;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class ConfigurationBuilder<C> {
    private final TypeToken<C> configType;
    private @Nullable Locale locale;
    private final List<TypeLiaison> typeLiaisons = new ArrayList<TypeLiaison>();
    private @Nullable KeyMapper keyMapper;
    private @Nullable MethodHandles.Lookup lookup;
    private @Nullable ReflectionService reflectionService;
    private final List<Migration<?, C>> migrations = new ArrayList();

    public ConfigurationBuilder(@NonNull TypeToken<C> configType) {
        this.configType = Objects.requireNonNull(configType, "config type");
    }

    public @This @NonNull ConfigurationBuilder<C> locale(@NonNull Locale locale) {
        assert ((this.locale = locale) != null) : "null locale";
        return this;
    }

    public @This @NonNull ConfigurationBuilder<C> addTypeLiaisons(TypeLiaison ... typeLiaisons) {
        this.typeLiaisons.addAll(Arrays.asList(typeLiaisons));
        return this;
    }

    public @This @NonNull ConfigurationBuilder<C> addTypeLiaisons(@NonNull List<@NonNull TypeLiaison> typeLiaisons) {
        this.typeLiaisons.addAll(typeLiaisons);
        return this;
    }

    public @This @NonNull ConfigurationBuilder<C> addPrimitiveTypeLiaisons() {
        return this.addTypeLiaisons(new CharacterLiaison(), new FloatLiaison(), new DoubleLiaison(), new BooleanLiaison(), new ByteLiaison(), new ShortLiaison(), new IntegerLiaison(), new LongLiaison(), new StringLiaison());
    }

    public @This @NonNull ConfigurationBuilder<C> addDefaultTypeLiaisons() {
        return this.addPrimitiveTypeLiaisons().addTypeLiaisons(new CollectionLiaison(), new MapLiaison(), new EnumLiaison(), new SubSectionLiaison());
    }

    public <V> @This @NonNull ConfigurationBuilder<C> addSimpleSerializer(@NonNull TypeToken<V> typeToken, @NonNull SerializeDeserialize<V> serializeDeserialize) {
        return this.addTypeLiaisons(new SimpleTypeLiaison<V>(typeToken, serializeDeserialize));
    }

    public @This @NonNull ConfigurationBuilder<C> clearTypeLiaisons() {
        this.typeLiaisons.clear();
        return this;
    }

    public @This @NonNull ConfigurationBuilder<C> keyMapper(@Nullable KeyMapper keyMapper) {
        this.keyMapper = keyMapper;
        return this;
    }

    public @This @NonNull ConfigurationBuilder<C> lookup(@NonNull MethodHandles.Lookup lookup) {
        this.lookup = Objects.requireNonNull(lookup, "lookup");
        return this;
    }

    public @This @NonNull ConfigurationBuilder<C> reflectionService(@NonNull ReflectionService reflectionService) {
        this.reflectionService = Objects.requireNonNull(reflectionService, "reflectionService");
        return this;
    }

    public @This @NonNull ConfigurationBuilder<C> addMigration(@NonNull Migration<?, C> migration) {
        this.migrations.add(Objects.requireNonNull(migration));
        return this;
    }

    public @This @NonNull ConfigurationBuilder<C> addMigrations(@NonNull List<@NonNull Migration<?, C>> migrations) {
        this.migrations.addAll(migrations);
        return this;
    }

    @SideEffectFree
    public @NonNull Configuration<C> build() {
        List<TypeLiaison> typeLiaisons = ImmutableCollections.listOf(this.typeLiaisons);
        List<Migration<?, C>> migrations = ImmutableCollections.listOf(this.migrations);
        MethodHandles.Lookup lookup = this.lookup == null ? MethodHandles.lookup() : this.lookup;
        ReflectionService reflectionService = this.reflectionService == null ? new DefaultReflectionService() : this.reflectionService;
        Locale locale = this.locale == null ? Locale.getDefault() : this.locale;
        LibraryLang libraryLang = LibraryLang.loadLang(locale);
        ConfigurationDefinition<C> definition = new DefinitionScan.Run<C>(new DefinitionScan(libraryLang, new LiaisonCache(typeLiaisons), reflectionService.makeInstantiator(lookup), reflectionService.makeMethodMirror(lookup)), this.configType).read();
        return new BuiltConfig<C>(definition, locale, libraryLang, typeLiaisons, this.keyMapper, migrations);
    }
}

