/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Configuration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigurationBuilder;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigurationDefinition;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.DeveloperMistakeException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DefaultKeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.DefaultReflectionService;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.ReflectionService;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.TypeToken;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class ConfigurationBuildTest {
    private final TypeToken<Config<String>> configType = new TypeToken<Config<String>>(this){};

    @Test
    public void locale() {
        Locale locale = Locale.CHINA;
        Assertions.assertSame((Object)locale, (Object)Configuration.defaultBuilder(this.configType).locale(locale).build().getLocale());
    }

    @Test
    public void clearLiaisons() {
        Assertions.assertFalse((boolean)Configuration.defaultBuilder(this.configType).build().getTypeLiaisons().isEmpty());
        Assertions.assertTrue((boolean)Configuration.defaultBuilder(this.configType).clearTypeLiaisons().build().getTypeLiaisons().isEmpty());
    }

    @Test
    public void keyMapper() {
        Assertions.assertNull((Object)Configuration.defaultBuilder(this.configType).build().getKeyMapper());
        DefaultKeyMapper keyMapper = new DefaultKeyMapper();
        Assertions.assertEquals((Object)keyMapper, (Object)Configuration.defaultBuilder(this.configType).keyMapper(keyMapper).build().getKeyMapper());
    }

    @Test
    public void reflectionService(@Mock ReflectionService reflectionService) {
        DefaultReflectionService defaultReflectionService = new DefaultReflectionService();
        Mockito.when((Object)reflectionService.makeInstantiator((MethodHandles.Lookup)ArgumentMatchers.any())).thenReturn((Object)defaultReflectionService.makeInstantiator(MethodHandles.lookup()));
        Mockito.when((Object)reflectionService.makeMethodMirror((MethodHandles.Lookup)ArgumentMatchers.any())).thenReturn((Object)defaultReflectionService.makeMethodMirror(MethodHandles.lookup()));
        ConfigurationBuilder<Config<String>> builder = Configuration.defaultBuilder(this.configType).reflectionService(reflectionService);
        ConfigurationDefinition.Layout layout = ((Configuration)Assertions.assertDoesNotThrow(builder::build)).getLayout();
        Assertions.assertNotNull((Object)layout.getInstantiator());
        Assertions.assertNotNull((Object)layout.getMethodMirror());
        ((ReflectionService)Mockito.verify((Object)reflectionService)).makeInstantiator((MethodHandles.Lookup)ArgumentMatchers.any());
        ((ReflectionService)Mockito.verify((Object)reflectionService)).makeMethodMirror((MethodHandles.Lookup)ArgumentMatchers.any());
    }

    @Test
    public void type() {
        Assertions.assertSame(this.configType, Configuration.defaultBuilder(this.configType).build().getType());
        Assertions.assertThrows(NullPointerException.class, () -> Configuration.defaultBuilder((Class)null));
        Assertions.assertThrows(NullPointerException.class, () -> Configuration.defaultBuilder((TypeToken)null));
        Assertions.assertThrows(DeveloperMistakeException.class, () -> Configuration.defaultBuilder(Config.class));
    }

    public static interface Config<A> {
    }
}

