/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigurationBuilder;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigurationDefinition;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigureListener;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.DeveloperMistakeException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ErrorPrint;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ReloadShell;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Backend;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.TypeLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.UpdateListener;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.migration.Migration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.ReifiedType;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.TypeToken;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Configuration<C>
extends ConfigurationDefinition<C> {
    public @NonNull Locale getLocale();

    public @NonNull List<@NonNull TypeLiaison> getTypeLiaisons();

    public @Nullable KeyMapper getKeyMapper();

    public @NonNull List<@NonNull Migration<?, C>> getMigrations();

    public static <C> @NonNull ConfigurationBuilder<C> defaultBuilder(@NonNull Class<C> configType) {
        if (configType.getTypeParameters().length != 0) {
            throw new DeveloperMistakeException("Cannot use Configuration.builder(Class) with a generic type.");
        }
        return Configuration.defaultBuilder(new TypeToken(new ReifiedType.Annotated(configType, ReifiedType.Annotated.EMPTY_ARRAY, ReifiedType.Annotated.unannotated())));
    }

    public static <C> @NonNull ConfigurationBuilder<C> defaultBuilder(@NonNull TypeToken<C> configType) {
        return new ConfigurationBuilder<C>(configType).addDefaultTypeLiaisons();
    }

    public @NonNull LoadResult<@NonNull C> readFrom(@NonNull DataTree var1);

    public @NonNull LoadResult<@NonNull C> readFrom(@NonNull DataTree var1, @NonNull UpdateListener var2);

    public void writeTo(@NonNull C var1, @NonNull DataTree.Mut var2);

    public @NonNull LoadResult<@NonNull C> configureWith(@NonNull Backend var1);

    public @NonNull LoadResult<@NonNull C> configureWith(@NonNull Backend var1, @NonNull ConfigureListener var2);

    public @NonNull C configureOrFallback(@NonNull Backend var1, @NonNull ErrorPrint var2);

    public @NonNull C configureOrFallback(@NonNull Backend var1, @NonNull ConfigureListener var2, @NonNull ErrorPrint var3);

    public @NonNull ReloadShell<C> makeReloadShell(@Nullable C var1);

    public  @NonNull ErrorContext.Source makeErrorSource();
}

