/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Configuration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigurationDefinition;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ConfigureListener;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ErrorContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ErrorPrint;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadError;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ReloadShell;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Backend;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.CommentData;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DefaultKeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyPath;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Printable;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.CommentLocation;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.TypeLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.UpdateListener;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.UpdateReason;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.lang.LibraryLang;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.migration.MigrateContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.migration.Migration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.TypeToken;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class BuiltConfig<C>
implements Configuration<C> {
    private final ConfigurationDefinition<C> definition;
    private final Locale locale;
    private final LibraryLang libraryLang;
    private final List<TypeLiaison> typeLiaisons;
    private final KeyMapper keyMapper;
    private final List<Migration<?, C>> migrations;

    BuiltConfig(ConfigurationDefinition<C> definition, Locale locale, LibraryLang libraryLang, List<TypeLiaison> typeLiaisons, KeyMapper keyMapper, List<Migration<?, C>> migrations) {
        this.definition = Objects.requireNonNull(definition);
        this.locale = Objects.requireNonNull(locale);
        this.libraryLang = Objects.requireNonNull(libraryLang);
        this.keyMapper = keyMapper;
        this.typeLiaisons = Objects.requireNonNull(typeLiaisons);
        this.migrations = Objects.requireNonNull(migrations);
    }

    @Override
    public @NonNull Locale getLocale() {
        return this.locale;
    }

    @Override
    public @NonNull List<@NonNull TypeLiaison> getTypeLiaisons() {
        return this.typeLiaisons;
    }

    @Override
    public @Nullable KeyMapper getKeyMapper() {
        return this.keyMapper;
    }

    @Override
    public @NonNull List<@NonNull Migration<?, C>> getMigrations() {
        return this.migrations;
    }

    @Override
    public @NonNull TypeToken<C> getType() {
        return this.definition.getType();
    }

    @Override
    public @NonNull ConfigurationDefinition.Layout getLayout() {
        return this.definition.getLayout();
    }

    @Override
    public @NonNull C loadDefaults() {
        return this.definition.loadDefaults();
    }

    @Override
    public @NonNull LoadResult<@NonNull C> readFrom(@NonNull DataTree dataTree, @NonNull ConfigurationDefinition.ReadOptions readOptions) {
        Objects.requireNonNull(dataTree, "dataTree");
        Objects.requireNonNull(readOptions, "readOptions");
        return this.definition.readFrom(dataTree, readOptions);
    }

    @Override
    public @NonNull LoadResult<@NonNull C> readWithUpdate(@NonNull DataTree.Mut dataTree, @NonNull ConfigurationDefinition.ReadWithUpdateOptions readOptions) {
        Objects.requireNonNull(dataTree, "dataTree");
        Objects.requireNonNull(readOptions, "readOptions");
        return this.definition.readWithUpdate(dataTree, readOptions);
    }

    @Override
    public void writeTo(@NonNull C config, @NonNull DataTree.Mut dataTree, @NonNull ConfigurationDefinition.WriteOptions writeOptions) {
        Objects.requireNonNull(config, "config");
        Objects.requireNonNull(dataTree, "dataTree");
        Objects.requireNonNull(writeOptions, "writeOptions");
        this.definition.writeTo(config, dataTree, writeOptions);
    }

    @Override
    public @NonNull LoadResult<@NonNull C> readFrom(@NonNull DataTree dataTree) {
        return this.readFrom(dataTree, (KeyPath entryPath, UpdateReason updateReason) -> {});
    }

    @Override
    public @NonNull LoadResult<@NonNull C> readFrom(@NonNull DataTree dataTree, final @NonNull UpdateListener updateListener) {
        final KeyMapper keyMapper = this.keyMapper != null ? this.keyMapper : new DefaultKeyMapper();
        return this.readFrom(dataTree, new ConfigurationDefinition.ReadOptions(){

            @Override
            public void notifyUpdate(@NonNull KeyPath entryPath, @NonNull UpdateReason updateReason) {
                updateListener.notifyUpdate(entryPath, updateReason);
            }

            @Override
            public @NonNull KeyMapper keyMapper() {
                return keyMapper;
            }

            @Override
            public @NonNull KeyPath keyPath() {
                return KeyPath.empty();
            }
        });
    }

    @Override
    public void writeTo(@NonNull C config, @NonNull DataTree.Mut dataTree) {
        KeyMapper keyMapper = this.keyMapper != null ? this.keyMapper : new DefaultKeyMapper();
        this.writeTo(config, dataTree, () -> keyMapper);
    }

    @Override
    public @NonNull LoadResult<@NonNull C> configureWith(@NonNull Backend backend) {
        return this.configureWith0(backend, new ConfigureListener(){

            @Override
            public void wroteDefaults() {
            }

            @Override
            public void migratedFrom(@NonNull Migration<?, ?> migration) {
            }

            @Override
            public void migrationSkip(@NonNull Migration<?, ?> migration, @NonNull List<@NonNull ErrorContext> errorContexts) {
            }

            @Override
            public void notifyUpdate(@NonNull KeyPath entryPath, @NonNull UpdateReason updateReason) {
            }
        });
    }

    @Override
    public @NonNull LoadResult<@NonNull C> configureWith(@NonNull Backend backend, @NonNull ConfigureListener configureListener) {
        Objects.requireNonNull(configureListener, "configureListener");
        return this.configureWith0(backend, configureListener);
    }

    private LoadResult<C> configureWith0(@NonNull Backend backend, @NonNull ConfigureListener configureListener) {
        ErrorContext.Source errorSource = this.makeErrorSource();
        try (CachedBackend cachedBackend = new CachedBackend(backend);){
            cachedBackend.initialLoad(errorSource);
            LoadResult<C> loadResult = this.implConfigureWith(cachedBackend, errorSource, configureListener);
            return loadResult;
        }
    }

    private LoadResult<C> implConfigureWith(final @NonNull CachedBackend backend, final @NonNull ErrorContext.Source errorSource, final @NonNull ConfigureListener configureListener) {
        ReadWithUpdateOpts readWithUpdateOpts;
        LoadResult<C> loadResult;
        LoadResult<Backend.Document> read;
        final ConfigurationDefinition.Layout layout = this.getLayout();
        final KeyMapper keyMapper = this.keyMapper != null ? this.keyMapper : backend.recommendKeyMapper();
        Objects.requireNonNull(keyMapper, "Backend returned null key mapper");
        if (!this.migrations.isEmpty()) {
            class MigrateCtx
            implements MigrateContext {
                MigrateCtx() {
                }

                @Override
                public @NonNull Backend mainBackend() {
                    return backend;
                }

                @Override
                public void notifyUpdate(@NonNull KeyPath entryPath, @NonNull UpdateReason updateReason) {
                    configureListener.notifyUpdate(entryPath, UpdateReason.MIGRATED);
                }

                @Override
                public @NonNull ErrorContext.Source errorSource() {
                    return errorSource;
                }
            }
            MigrateCtx migrateCtx = new MigrateCtx();
            for (Migration<?, C> migration : this.migrations) {
                LoadResult<C> attempt = migration.tryMigrate(migrateCtx);
                if (attempt.isSuccess()) {
                    C migrated = attempt.getOrThrow();
                    final DataTree.Mut migratedData = new DataTree.Mut();
                    this.writeTo(migrated, migratedData, () -> keyMapper);
                    backend.write(new Backend.Document(){

                        @Override
                        public @NonNull CommentData comments() {
                            return layout.getComments();
                        }

                        @Override
                        public @NonNull DataTree data() {
                            return migratedData;
                        }
                    });
                    migration.onCompletion();
                    configureListener.migratedFrom(migration);
                    return attempt;
                }
                configureListener.migrationSkip(migration, attempt.getErrorContexts());
            }
        }
        if ((read = backend.readOwned()).isFailure()) {
            return LoadResult.failure(read.getErrorContexts());
        }
        final Backend.Document document = read.getOrThrow();
        if (document == null) {
            C defaults = this.loadDefaults();
            final DataTree.Mut defaultData = new DataTree.Mut();
            this.writeTo(defaults, defaultData, () -> keyMapper);
            backend.write(new Backend.Document(){

                @Override
                public @NonNull CommentData comments() {
                    return layout.getComments();
                }

                @Override
                public @NonNull DataTree data() {
                    return defaultData;
                }
            });
            configureListener.wroteDefaults();
            return LoadResult.of(defaults);
        }
        final DataTree.Mut updatableTree = document.data().intoMut();
        if (backend.meta().preservesOrder(true) || backend.meta().preservesOrder(false)) {
            // empty if block
        }
        class ReadWithUpdateOpts
        implements ConfigurationDefinition.ReadWithUpdateOptions {
            boolean updated;

            ReadWithUpdateOpts() {
            }

            @Override
            public void notifyUpdate(@NonNull KeyPath entryPath, @NonNull UpdateReason updateReason) {
                this.updated = true;
                configureListener.notifyUpdate(entryPath, updateReason);
            }

            @Override
            public @NonNull KeyMapper keyMapper() {
                return keyMapper;
            }

            @Override
            public @NonNull KeyPath keyPath() {
                return KeyPath.empty();
            }

            @Override
            public boolean writeEntryComments(@NonNull CommentLocation location) {
                return backend.shouldRefreshComments(false, location);
            }
        }
        if ((loadResult = this.readWithUpdate(updatableTree, readWithUpdateOpts = new ReadWithUpdateOpts())).isSuccess() && readWithUpdateOpts.updated) {
            backend.write(new Backend.Document(){

                @Override
                public @NonNull CommentData comments() {
                    CommentData fromLayout = BuiltConfig.this.getLayout().getComments();
                    CommentData current = document.comments();
                    for (CommentLocation location : CommentLocation.values()) {
                        if (!backend.shouldRefreshComments(true, location)) continue;
                        current = current.setAt(location, fromLayout.getAt(location));
                    }
                    return current;
                }

                @Override
                public @NonNull DataTree data() {
                    return updatableTree;
                }
            });
        }
        return loadResult;
    }

    @Override
    public @NonNull C configureOrFallback(@NonNull Backend backend, @NonNull ErrorPrint errorPrint) {
        return this.handleErrors(this.configureWith(backend), errorPrint);
    }

    @Override
    public @NonNull C configureOrFallback(@NonNull Backend backend, @NonNull ConfigureListener configureListener, @NonNull ErrorPrint errorPrint) {
        return this.handleErrors(this.configureWith(backend, configureListener), errorPrint);
    }

    private C handleErrors(LoadResult<C> result, ErrorPrint errorPrint) {
        if (result.isSuccess()) {
            return result.getOrThrow();
        }
        errorPrint.onError(result.getErrorContexts());
        return this.loadDefaults();
    }

    @Override
    public @NonNull ReloadShell<C> makeReloadShell(@Nullable C initialValue) {
        ReloadShell<C> reloadShell = this.getLayout().getInstantiator().generateShell(this.getType().getRawType());
        reloadShell.setCurrentDelegate(initialValue);
        return reloadShell;
    }

    @Override
    public @NonNull ErrorContext.Source makeErrorSource() {
        return new LoadError.Factory(){

            @Override
            public @NonNull ErrorContext buildError(@NonNull Printable message) {
                return new LoadError(message, BuiltConfig.this.libraryLang);
            }

            @Override
            public @NonNull LibraryLang getLibraryLang() {
                return BuiltConfig.this.libraryLang;
            }
        };
    }

    private static final class CachedBackend
    implements Backend,
    AutoCloseable {
        private final Backend delegate;
        private final Backend.Meta meta;
        private List<ErrorContext> currentErrors;
        private Backend.Document currentDoc;
        private boolean changed;

        CachedBackend(Backend delegate) {
            this.delegate = delegate;
            this.meta = delegate.meta();
        }

        void initialLoad(@NonNull ErrorContext.Source errorSource) {
            LoadResult<Backend.Document> initialDoc = this.delegate.read(errorSource);
            if (initialDoc.isSuccess()) {
                this.currentDoc = initialDoc.getOrThrow();
            } else {
                this.currentErrors = initialDoc.getErrorContexts();
            }
        }

        @Override
        public @NonNull LoadResult<@Nullable Backend.Document> read(@NonNull ErrorContext.Source errorSource) {
            if (this.currentErrors != null) {
                return LoadResult.failure(this.currentErrors);
            }
            final Backend.Document readDoc = this.currentDoc;
            if (readDoc == null) {
                return LoadResult.of(null);
            }
            return LoadResult.of(new Backend.Document(){

                @Override
                public @NonNull CommentData comments() {
                    return readDoc.comments();
                }

                @Override
                public @NonNull DataTree data() {
                    return readDoc.data().intoImmut();
                }
            });
        }

        LoadResult<@Nullable Backend.Document> readOwned() {
            if (this.currentErrors != null) {
                return LoadResult.failure(this.currentErrors);
            }
            return LoadResult.of(this.currentDoc);
        }

        @Override
        public void write(@NonNull Backend.Document document) {
            this.changed = true;
            this.currentErrors = null;
            this.currentDoc = document;
        }

        @Override
        public void close() {
            if (this.changed) {
                this.delegate.write(this.currentDoc);
            }
        }

        @Override
        public @NonNull KeyMapper recommendKeyMapper() {
            return this.delegate.recommendKeyMapper();
        }

        @Override
        public @NonNull Backend.Meta meta() {
            return this.meta;
        }

        boolean shouldRefreshComments(boolean documentLevel, CommentLocation location) {
            boolean supportsReading = this.meta.supportsComments(documentLevel, true, location);
            boolean supportsWriting = this.meta.supportsComments(documentLevel, false, location);
            return !supportsReading && supportsWriting;
        }
    }
}

