/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Configuration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.CallableFn;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodId;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.MethodMirror;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.TypeToken;
import java.lang.reflect.InvocationTargetException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class AmbiguousMethodTest {
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void callTrouble(boolean fromData) {
        Config config;
        Configuration<Config> configuration = Configuration.defaultBuilder(Config.class).build();
        if (fromData) {
            DataTree.Mut dataTree = new DataTree.Mut();
            dataTree.put("trouble", new DataEntry(-2));
            config = configuration.readFrom(dataTree).getOrThrow();
        } else {
            config = (Config)configuration.loadDefaults();
        }
        Assertions.assertEquals((int)(fromData ? -2 : -1), (int)config.trouble());
        Assertions.assertEquals((int)2, (int)config.trouble(2));
        Assertions.assertEquals((int)3, (int)config.trouble(3));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void invokeTrouble(boolean fromData) throws InvocationTargetException {
        Config config;
        Configuration<Config> configuration = Configuration.defaultBuilder(Config.class).build();
        if (fromData) {
            DataTree.Mut dataTree = new DataTree.Mut();
            dataTree.put("trouble", new DataEntry(-2));
            config = configuration.readFrom(dataTree).getOrThrow();
        } else {
            config = (Config)configuration.loadDefaults();
        }
        MethodMirror methodMirror = configuration.getLayout().getMethodMirror();
        MethodMirror.Invoker invoker = methodMirror.makeInvoker(config, Config.class);
        MethodMirror.TypeWalker configTypeWalk = methodMirror.typeWalker(new TypeToken<Config>(this){}.getReifiedType());
        MethodId troublePlain = configTypeWalk.getViableMethods().filter(methodId -> methodId.parameterCount() == 0).findAny().orElseThrow();
        Assertions.assertEquals((Object)(fromData ? -2 : -1), (Object)invoker.invokeMethod(troublePlain, new Object[0]));
        MethodId troubleRet = configTypeWalk.getViableMethods().filter(methodId -> methodId.parameterCount() == 1).findAny().orElseThrow();
        Assertions.assertEquals((Object)2, (Object)invoker.invokeMethod(troubleRet, 2));
        Assertions.assertEquals((Object)3, (Object)invoker.invokeMethod(troubleRet, 3));
    }

    @Test
    public void invokeTroubleNonProxyInstance() throws InvocationTargetException {
        Configuration<Config> configuration = Configuration.defaultBuilder(Config.class).build();
        Config config = new Config(this){

            @Override
            public int trouble() {
                return -4;
            }

            @Override
            public int trouble(int ret) {
                return ret * 2;
            }
        };
        MethodMirror methodMirror = configuration.getLayout().getMethodMirror();
        MethodMirror.Invoker invoker = methodMirror.makeInvoker(config, Config.class);
        MethodMirror.TypeWalker configTypeWalk = methodMirror.typeWalker(new TypeToken<Config>(this){}.getReifiedType());
        MethodId troublePlain = configTypeWalk.getViableMethods().filter(methodId -> methodId.parameterCount() == 0).findAny().orElseThrow();
        Assertions.assertEquals((Object)-4, (Object)invoker.invokeMethod(troublePlain, new Object[0]));
        MethodId troubleRet = configTypeWalk.getViableMethods().filter(methodId -> methodId.parameterCount() == 1).findAny().orElseThrow();
        Assertions.assertEquals((Object)4, (Object)invoker.invokeMethod(troubleRet, 2));
        Assertions.assertEquals((Object)6, (Object)invoker.invokeMethod(troubleRet, 3));
    }

    public static interface Config {
        default public int trouble() {
            return -1;
        }

        @CallableFn
        default public int trouble(int ret) {
            return ret;
        }
    }
}

