/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.config;

import fi.fabianadrian.nightaccelerator.NightAccelerator;
import fi.fabianadrian.nightaccelerator.config.MainConfig;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Configuration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.StandardErrorPrint;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Backend;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.PathRoot;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.TomlBackend;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;

public final class ConfigManager {
    private final Configuration<MainConfig> configuration;
    private final Backend backend;
    private final StandardErrorPrint errorPrint;
    private final Path dataDirectory;
    private final Logger logger;
    private MainConfig config;

    public ConfigManager(NightAccelerator plugin) {
        this.dataDirectory = plugin.getDataPath();
        this.logger = plugin.getSLF4JLogger();
        this.configuration = Configuration.defaultBuilder(MainConfig.class).build();
        this.backend = new TomlBackend(new PathRoot(this.dataDirectory.resolve("config.toml")));
        this.errorPrint = new StandardErrorPrint(output -> this.logger.error(output.printString()));
    }

    public void load() {
        try {
            Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.logger.error("Failed to create dataDirectory", (Throwable)e);
        }
        this.config = this.configuration.configureOrFallback(this.backend, this.errorPrint);
    }

    public MainConfig config() {
        return this.config;
    }
}

