/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import fi.fabianadrian.nightaccelerator.NightAccelerator;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.plugin.Plugin;

public final class NightAcceleratorCommand {
    private static final Component COMPONENT_PREFIX = MiniMessage.miniMessage().deserialize((Object)"[<#60a5fa>NightAccelerator</#60a5fa>] ");
    private static final Component COMPONENT_RELOAD_SUCCESS = COMPONENT_PREFIX.append((Component)Component.translatable((String)"nightaccelerator.command.reload.success", (TextColor)NamedTextColor.GREEN));
    private static final Component COMPONENT_RELOAD_FAILURE = COMPONENT_PREFIX.append((Component)Component.translatable((String)"nightaccelerator.command.reload.failure", (TextColor)NamedTextColor.RED));
    private static final String PERMISSION_RELOAD = "nightaccelerator.command.reload";
    private final NightAccelerator plugin;
    private final LifecycleEventManager<Plugin> manager;

    public NightAcceleratorCommand(NightAccelerator plugin) {
        this.plugin = plugin;
        this.manager = plugin.getLifecycleManager();
    }

    public void register() {
        LiteralArgumentBuilder rootBuilder = (LiteralArgumentBuilder)Commands.literal((String)"nightaccelerator").requires(stack -> stack.getSender().hasPermission(PERMISSION_RELOAD));
        LiteralCommandNode reloadNode = ((LiteralArgumentBuilder)rootBuilder.then(Commands.literal((String)"reload").executes(this::executeReload))).build();
        this.manager.registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            Commands commands = (Commands)event.registrar();
            commands.register(reloadNode);
        });
    }

    private int executeReload(CommandContext<CommandSourceStack> ctx) {
        try {
            this.plugin.load();
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(COMPONENT_RELOAD_SUCCESS);
        }
        catch (Throwable e) {
            this.plugin.getSLF4JLogger().error("Couldn't reload plugin", e);
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(COMPONENT_RELOAD_FAILURE);
        }
        return 1;
    }
}

