/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator;

import fi.fabianadrian.nightaccelerator.command.NightAcceleratorCommand;
import fi.fabianadrian.nightaccelerator.config.ConfigManager;
import fi.fabianadrian.nightaccelerator.config.MainConfig;
import fi.fabianadrian.nightaccelerator.dependency.org.bstats.bukkit.Metrics;
import fi.fabianadrian.nightaccelerator.listener.BedListener;
import fi.fabianadrian.nightaccelerator.listener.PlayerListener;
import fi.fabianadrian.nightaccelerator.listener.ServerListener;
import fi.fabianadrian.nightaccelerator.locale.TranslationManager;
import fi.fabianadrian.nightaccelerator.placeholder.PlaceholderManager;
import fi.fabianadrian.nightaccelerator.tagresolver.TagResolverFactory;
import fi.fabianadrian.nightaccelerator.world.WorldManager;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class NightAccelerator
extends JavaPlugin {
    public static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final PlaceholderManager placeholderManager = new PlaceholderManager(this);
    private final TagResolverFactory resolverFactory = new TagResolverFactory();
    private final WorldManager worldManager = new WorldManager(this);
    private ConfigManager configManager;

    public void onEnable() {
        new TranslationManager(this.getSLF4JLogger());
        this.configManager = new ConfigManager(this);
        this.registerListeners();
        new NightAcceleratorCommand(this).register();
        this.placeholderManager.register();
        new Metrics((Plugin)this, 29528);
    }

    public void load() {
        this.configManager.load();
        this.worldManager.load();
    }

    public MainConfig config() {
        return this.configManager.config();
    }

    public WorldManager worldManager() {
        return this.worldManager;
    }

    public TagResolverFactory resolverFactory() {
        return this.resolverFactory;
    }

    public ScheduledExecutorService executorService() {
        return this.executorService;
    }

    private void registerListeners() {
        PluginManager manager = this.getServer().getPluginManager();
        List.of(new BedListener(this), new PlayerListener(this), new ServerListener(this)).forEach(listener -> manager.registerEvents(listener, (Plugin)this));
    }
}

