/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ImmutableCollections {
    private ImmutableCollections() {
    }

    public static <E> List<E> emptyList() {
        return List.of();
    }

    public static <E> List<E> listOf(E element) {
        return List.of(element);
    }

    @SafeVarargs
    public static <E> List<E> listOf(E ... elements) {
        return List.of(elements);
    }

    public static <E> List<E> listOf(Collection<? extends E> coll) {
        return List.copyOf(coll);
    }

    public static <E> Set<E> emptySet() {
        return Set.of();
    }

    public static <E> Set<E> setOf(E element) {
        return Set.of(element);
    }

    public static <E> Set<E> setOf(Collection<? extends E> coll) {
        return Set.copyOf(coll);
    }

    public static <K, V> Map<K, V> emptyMap() {
        return Map.of();
    }

    public static <K, V> Map<K, V> mapOf(Map<? extends K, ? extends V> map) {
        return Map.copyOf(map);
    }

    public static <K, V> Map.Entry<K, V> mapEntryOf(K key, V value) {
        return Map.entry(key, value);
    }
}

