/*
 * Decompiled with CFR 0.152.
 */
package net.mvndicraft.townywaypoints.util;

import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import net.mvndicraft.townywaypoints.Waypoint;
import net.mvndicraft.townywaypoints.settings.TownyWaypointsSettings;
import net.mvndicraft.townywaypoints.util.TownBlockMetaDataController;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

public class LocationUtil {
    public static boolean isSafe(Location location) {
        Block feet = location.getBlock();
        if (!feet.getType().isAir()) {
            return false;
        }
        Block head = feet.getRelative(BlockFace.UP);
        if (!head.getType().isAir()) {
            return false;
        }
        Block ground = feet.getRelative(BlockFace.DOWN);
        return ground.getType().isSolid();
    }

    public static boolean isCloseEnough(Player player, Waypoint waypoint, Town town) {
        if (player.hasPermission("townywaypoints.admin")) {
            return true;
        }
        return town.getTownBlocks().stream().anyMatch(townBlock -> townBlock.getType().getName().equals(waypoint.getName()) && LocationUtil.getDistance(player, townBlock) <= (double)LocationUtil.getMaxDistance(waypoint));
    }

    public static int getMaxDistance(Waypoint waypoint) {
        return waypoint.getMaxDistance() != -1 ? waypoint.getMaxDistance() : TownyWaypointsSettings.getMaxDistance();
    }

    public static double getDistance(Player player, TownBlock townBlock) {
        Location loc1 = TownBlockMetaDataController.getSpawn(townBlock);
        Location loc2 = player.getLocation();
        if (loc1.getWorld() == null || loc2.getWorld() == null || !loc1.getWorld().getUID().equals(loc2.getWorld().getUID())) {
            return Double.MAX_VALUE;
        }
        return loc1.distance(loc2);
    }
}

