/*
 * Decompiled with CFR 0.152.
 */
package net.mvndicraft.townywaypoints.settings;

import com.palmergames.bukkit.config.CommentedConfiguration;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.object.TranslationLoader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.mvndicraft.townywaypoints.TownyWaypoints;
import net.mvndicraft.townywaypoints.settings.ConfigNodes;
import org.bukkit.plugin.Plugin;

public class Settings {
    private static CommentedConfiguration config;
    private static CommentedConfiguration newConfig;

    public static void loadConfigAndLang() {
        Path path = TownyWaypoints.getInstance().getDataFolder().toPath().resolve("config.yml");
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                TownyWaypoints.getInstance().getLogger().warning("Failed to create config.yml!");
                e.printStackTrace();
            }
        }
        if (!(config = new CommentedConfiguration(path)).load()) {
            TownyWaypoints.getInstance().getLogger().warning("Failed to load config.yml!");
        }
        Settings.setDefaults(path);
        config.save();
        TownyWaypoints instance = TownyWaypoints.getInstance();
        try {
            Path langFolderPath = Paths.get(instance.getDataFolder().getPath(), new String[0]).resolve("lang");
            TranslationLoader loader = new TranslationLoader(langFolderPath, (Plugin)instance, TownyWaypoints.class);
            loader.load();
            TownyAPI.getInstance().addTranslations((Plugin)instance, loader.getTranslations());
        }
        catch (Exception e) {
            instance.getLogger().severe("Language file failed to load! Disabling!");
        }
    }

    public static void addComment(String root, String ... comments) {
        newConfig.addComment(root.toLowerCase(), comments);
    }

    private static void setNewProperty(String root, Object value) {
        if (value == null) {
            value = "";
        }
        newConfig.set(root.toLowerCase(), (Object)value.toString());
    }

    private static void setProperty(String root, Object value) {
        config.set(root.toLowerCase(), (Object)value.toString());
    }

    private static void setDefaults(Path configPath) {
        newConfig = new CommentedConfiguration(configPath);
        newConfig.load();
        for (ConfigNodes root : ConfigNodes.values()) {
            if (root.getComments().length > 0) {
                Settings.addComment(root.getRoot(), root.getComments());
            }
            if (root == ConfigNodes.VERSION) {
                Settings.setNewProperty(root.getRoot(), TownyWaypoints.getInstance().getVersion());
                continue;
            }
            Settings.setNewProperty(root.getRoot(), config.get(root.getRoot().toLowerCase()) != null ? config.get(root.getRoot().toLowerCase()) : root.getDefault());
        }
        config = newConfig;
        newConfig = null;
    }

    public static String getString(String root, String def) {
        String data = config.getString(root.toLowerCase(), def);
        if (data == null) {
            TownyWaypoints.getInstance().getLogger().warning("Failed to read " + root.toLowerCase() + " from config.yml");
            return "";
        }
        return data;
    }

    public static boolean getBoolean(ConfigNodes node) {
        return Boolean.parseBoolean(config.getString(node.getRoot().toLowerCase(), node.getDefault()));
    }

    public static double getDouble(ConfigNodes node) {
        try {
            return Double.parseDouble(config.getString(node.getRoot().toLowerCase(), node.getDefault()).trim());
        }
        catch (NumberFormatException e) {
            TownyWaypoints.getInstance().getLogger().warning("Failed to read " + node.getRoot().toLowerCase() + " from config.yml");
            return 0.0;
        }
    }

    public static int getInt(ConfigNodes node) {
        try {
            return Integer.parseInt(config.getString(node.getRoot().toLowerCase(), node.getDefault()).trim());
        }
        catch (NumberFormatException e) {
            TownyWaypoints.getInstance().getLogger().warning("Failed to read " + node.getRoot().toLowerCase() + " from config.yml");
            return 0;
        }
    }

    public static String getString(ConfigNodes node) {
        return config.getString(node.getRoot().toLowerCase(), node.getDefault());
    }
}

