/*
 * Decompiled with CFR 0.152.
 */
package net.mvndicraft.townywaypoints.listeners;

import com.palmergames.bukkit.towny.event.PlotPreChangeTypeEvent;
import com.palmergames.bukkit.towny.event.TownBlockTypeRegisterEvent;
import com.palmergames.bukkit.towny.event.TranslationLoadEvent;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockData;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownBlockTypeHandler;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.TranslationLoader;
import fr.formiko.mc.biomeutils.NMSBiomeUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import net.mvndicraft.townywaypoints.TownyWaypoints;
import net.mvndicraft.townywaypoints.Waypoint;
import net.mvndicraft.townywaypoints.util.Messaging;
import net.mvndicraft.townywaypoints.util.TownBlockMetaDataController;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public final class TownyListener
implements Listener {
    private static final TownyWaypoints instance = TownyWaypoints.getInstance();

    public static void registerPlot(String name, final String mapKey, final double cost) {
        if (TownBlockTypeHandler.exists((String)name)) {
            return;
        }
        TownBlockType townBlockType = new TownBlockType(name, new TownBlockData(){

            public String getMapKey() {
                return mapKey;
            }

            public double getCost() {
                return cost;
            }
        });
        try {
            instance.getLogger().info("registering new plot type " + name);
            TownBlockTypeHandler.registerType((TownBlockType)townBlockType);
        }
        catch (TownyException e) {
            Bukkit.getLogger().severe(e.getMessage());
        }
    }

    private static boolean biomeAllowed(Location loc, Waypoint waypoint) {
        if (!waypoint.getAllowedBiomeTags().isEmpty()) {
            for (String tag : waypoint.getAllowedBiomeTags()) {
                if (!NMSBiomeUtils.matchTag(loc, tag)) continue;
                return true;
            }
        }
        if (waypoint.getAllowedBiomes().isEmpty()) {
            return waypoint.getAllowedBiomeTags().isEmpty();
        }
        return waypoint.getAllowedBiomes().contains(loc.getBlock().getBiome().toString());
    }

    @EventHandler
    public void onTownyLoadTownBlockTypes(TownBlockTypeRegisterEvent event) {
        TownyWaypoints.loadWaypoints();
    }

    private int getPlotTypeCount(Town town, String name) {
        int count = 0;
        for (TownBlock townBlock : town.getTownBlocks()) {
            if (!townBlock.getType().getName().equalsIgnoreCase(name)) continue;
            ++count;
        }
        return count;
    }

    @EventHandler
    public void onPlotPreChangeTypeEvent(PlotPreChangeTypeEvent event) throws NotRegisteredException {
        TownBlock townBlock = event.getTownBlock();
        String plotTypeName = event.getNewType().getName();
        if (!TownyWaypoints.getWaypoints().containsKey(plotTypeName)) {
            return;
        }
        Waypoint waypoint = TownyWaypoints.getWaypoints().get(plotTypeName);
        World world = townBlock.getWorld().getBukkitWorld();
        if (world == null) {
            return;
        }
        Player player = event.getResident().getPlayer();
        if (player == null) {
            return;
        }
        if (!waypoint.getPermission().isEmpty() && !player.hasPermission(waypoint.getPermission())) {
            event.setCancelMessage(Translatable.of((String)"msg_err_waypoint_create_insufficient_permission", (Object[])new Object[]{waypoint.getName()}).defaultLocale());
            event.setCancelled(true);
            return;
        }
        if (TownyWaypoints.getEconomy().balance("TownyWaypoints", player.getUniqueId()).doubleValue() - waypoint.getCost() <= 0.0) {
            event.setCancelMessage(Translatable.of((String)"msg_err_waypoint_create_insufficient_funds", (Object[])new Object[]{waypoint.getName(), waypoint.getCost()}).defaultLocale());
            event.setCancelled(true);
            return;
        }
        Location loc = player.getLocation();
        if (loc == null) {
            event.setCancelled(true);
            return;
        }
        if (!TownyListener.biomeAllowed(loc, waypoint)) {
            event.setCancelMessage(Translatable.of((String)"msg_err_biome_not_allowed", (Object[])new Object[]{loc.getBlock().getBiome().toString()}).defaultLocale());
            event.setCancelled(true);
            return;
        }
        int max = waypoint.getMax();
        if (this.getPlotTypeCount(townBlock.getTown(), plotTypeName) >= max) {
            event.setCancelMessage(Translatable.of((String)"msg_err_max_plots", (Object[])new Object[]{max}).defaultLocale());
            event.setCancelled(true);
            return;
        }
        Messaging.sendMsg((CommandSender)player, Translatable.of((String)"msg_spawn_set", (Object[])new Object[]{loc.toString()}));
        TownBlockMetaDataController.setSpawn(townBlock, player.getLocation());
    }

    @EventHandler(ignoreCancelled=true)
    public void onTownyLoadLanguages(TranslationLoadEvent event) {
        TownyWaypoints plugin = TownyWaypoints.getInstance();
        Path langFolderPath = Paths.get(plugin.getDataFolder().getPath(), new String[0]).resolve("lang");
        TranslationLoader loader = new TranslationLoader(langFolderPath, (Plugin)plugin, TownyWaypoints.class);
        loader.load();
        Map translations = loader.getTranslations();
        for (String language : translations.keySet()) {
            for (Map.Entry map : ((Map)translations.get(language)).entrySet()) {
                event.addTranslation(language, (String)map.getKey(), (String)map.getValue());
            }
        }
    }
}

